/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.mbstyle.layer.BackgroundMBLayer;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.layer.SymbolMBLayer;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.mbstyle.parse.MBObjectStops;
import org.geotools.mbstyle.source.MBSource;
import org.geotools.referencing.CRS;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactory2;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.UserLayer;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MBStyle {
    private static final int DEFAULT_LABEL_PRIORITY = 1000;
    public final JSONObject json;
    final MBObjectParser parse = new MBObjectParser(MBStyle.class);

    public MBStyle(JSONObject json) {
        this.json = json;
    }

    public static MBStyle create(Object json) throws MBFormatException {
        if (json instanceof JSONObject) {
            return new MBStyle((JSONObject)json);
        }
        if (json == null) {
            throw new MBFormatException("JSONObject required: null");
        }
        throw new MBFormatException("Root must be a JSON Object: " + json.toString());
    }

    public MBLayer layer(String id) {
        if (id == null) {
            return null;
        }
        for (MBLayer layer : this.layers()) {
            if (!id.equals(layer.getId())) continue;
            return layer;
        }
        return null;
    }

    public List<MBLayer> layers() {
        JSONArray layers = this.parse.getJSONArray(this.json, "layers");
        ArrayList<MBLayer> layersList = new ArrayList<MBLayer>();
        int labelPriority = 0;
        for (Object obj : layers) {
            if (obj instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)obj;
                MBLayer mbLayer = null;
                if (jsonObject.containsKey((Object)"ref")) {
                    String refLayer = jsonObject.get((Object)"ref").toString();
                    JSONObject refObject = this.referenceLayer(layers, refLayer);
                    if (refObject.size() > 0) {
                        this.applyReferenceObject(jsonObject, refObject);
                        mbLayer = MBLayer.create(jsonObject);
                    }
                } else {
                    mbLayer = MBLayer.create((JSONObject)obj);
                }
                if (mbLayer instanceof SymbolMBLayer) {
                    ((SymbolMBLayer)mbLayer).setLabelPriority(labelPriority += 1000);
                }
                layersList.add(mbLayer);
                continue;
            }
            throw new MBFormatException("Unexpected layer definition " + String.valueOf(obj));
        }
        return layersList;
    }

    private JSONObject referenceLayer(JSONArray layers, String refLayer) {
        JSONObject refObject = new JSONObject();
        for (Object check : layers) {
            if (!(check instanceof JSONObject) || !refLayer.equalsIgnoreCase(((JSONObject)check).get((Object)"id").toString())) continue;
            refObject = (JSONObject)check;
        }
        return refObject;
    }

    private JSONObject applyReferenceObject(JSONObject layer, JSONObject refLayer) {
        JSONObject jsonObject = layer;
        jsonObject.put("type", refLayer.get((Object)"type"));
        jsonObject.put("source", refLayer.get((Object)"source"));
        jsonObject.put("source-layer", refLayer.get((Object)"source-layer"));
        jsonObject.put("minzoom", refLayer.get((Object)"minzoom"));
        jsonObject.put("maxzoom", refLayer.get((Object)"maxzoom"));
        jsonObject.put("filter", refLayer.get((Object)"filter"));
        if (!jsonObject.containsKey("layout")) {
            jsonObject.put("layout", refLayer.get((Object)"layout"));
        }
        if (!jsonObject.containsKey("paint")) {
            jsonObject.put("paint", refLayer.get((Object)"paint"));
        }
        return layer;
    }

    public List<MBLayer> layers(String source) throws MBFormatException {
        JSONArray layers = this.parse.getJSONArray(this.json, "layers");
        ArrayList<MBLayer> layersList = new ArrayList<MBLayer>();
        for (Object obj : layers) {
            if (obj instanceof JSONObject) {
                JSONObject jsonObject = (JSONObject)obj;
                if (jsonObject.containsKey((Object)"ref")) {
                    String refLayer = jsonObject.get((Object)"ref").toString();
                    JSONObject refObject = this.referenceLayer(layers, refLayer);
                    if (refObject.size() <= 0) continue;
                    this.applyReferenceObject(jsonObject, refObject);
                    MBLayer layer = MBLayer.create(jsonObject);
                    if (!source.equals(layer.getSource())) continue;
                    layersList.add(layer);
                    continue;
                }
                MBLayer layer = MBLayer.create(jsonObject);
                if (!source.equals(layer.getSource())) continue;
                layersList.add(layer);
                continue;
            }
            throw new MBFormatException("Unexpected layer definition " + String.valueOf(obj));
        }
        return layersList;
    }

    public String getName() {
        return this.parse.optional(String.class, this.json, "name", null);
    }

    public JSONObject getMetadata() {
        return this.parse.getJSONObject(this.json, "metadata", new JSONObject());
    }

    public Point2D getCenter() {
        double[] coords = this.parse.array(this.json, "center", (double[])null);
        if (coords == null) {
            return null;
        }
        if (coords.length != 2) {
            throw new MBFormatException("\"center\" array must be length 2.");
        }
        return new Point2D.Double(coords[0], coords[1]);
    }

    public Number getZoom() {
        return this.parse.optional(Number.class, this.json, "zoom", null);
    }

    public Number getBearing() {
        return this.parse.optional(Number.class, this.json, "bearing", 0);
    }

    public Number getPitch() {
        return this.parse.optional(Number.class, this.json, "pitch", 0);
    }

    public String getSprite() {
        return this.parse.optional(String.class, this.json, "sprite", null);
    }

    public String getGlyphs() {
        return this.parse.optional(String.class, this.json, "glyphs", null);
    }

    public Map<String, MBSource> getSources() {
        HashMap<String, MBSource> sourceMap = new HashMap<String, MBSource>();
        JSONObject sources = this.parse.getJSONObject(this.json, "sources", new JSONObject());
        for (Object o : sources.keySet()) {
            if (!(o instanceof String)) continue;
            String k = (String)o;
            JSONObject j = this.parse.getJSONObject(sources, k);
            MBSource s = MBSource.create(j, this.parse);
            sourceMap.put(k, s);
        }
        return sourceMap;
    }

    public StyledLayerDescriptor transform() {
        StyleFactory2 sf = this.parse.getStyleFactory();
        StyledLayerDescriptor sld = sf.createStyledLayerDescriptor();
        List<MBLayer> layers = this.layers();
        if (layers.isEmpty()) {
            throw new MBFormatException("layers empty");
        }
        NamedLayer currentNamedLayer = null;
        String currentName = null;
        BackgroundMBLayer background = null;
        for (MBLayer layer : layers) {
            Double layerMaxScaleDenominator;
            ArrayList<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
            MBObjectStops mbObjectStops = new MBObjectStops(layer);
            int layerMaxZoom = layer.getMaxZoom();
            int layerMinZoom = layer.getMinZoom();
            Double layerMinScaleDenominator = layerMaxZoom == Integer.MAX_VALUE ? null : MBObjectStops.zoomLevelToScaleDenominator(Math.min(25.0, (double)layerMaxZoom));
            Double d = layerMaxScaleDenominator = layerMinZoom == Integer.MIN_VALUE ? null : MBObjectStops.zoomLevelToScaleDenominator(Math.max(-25.0, (double)layerMinZoom));
            if (layer.visibility()) {
                if (mbObjectStops.ls.zoomPropertyStops) {
                    List<Double> stopLevels = mbObjectStops.stops;
                    int i = 0;
                    for (MBLayer l : mbObjectStops.layersForStop) {
                        double s = stopLevels.get(i);
                        double[] rangeForStopLevel = mbObjectStops.getRangeForStop(s, mbObjectStops.ranges);
                        Double maxScaleDenominator = MBObjectStops.zoomLevelToScaleDenominator(rangeForStopLevel[0]);
                        Double minScaleDenominator = null;
                        if (rangeForStopLevel[1] != -1.0) {
                            minScaleDenominator = MBObjectStops.zoomLevelToScaleDenominator(rangeForStopLevel[1]);
                        }
                        featureTypeStyles.addAll(l.transform(this, minScaleDenominator, maxScaleDenominator));
                        ++i;
                    }
                } else if (layer instanceof BackgroundMBLayer) {
                    background = (BackgroundMBLayer)layer;
                } else {
                    featureTypeStyles.addAll(layer.transform(this, layerMinScaleDenominator, layerMaxScaleDenominator));
                }
            }
            if (featureTypeStyles.isEmpty() || layer instanceof BackgroundMBLayer) continue;
            String sourceLayer = layer.getSourceLayer();
            if (sourceLayer == null) {
                sourceLayer = layer.getSource();
            }
            if (currentNamedLayer == null || !sourceLayer.equals(currentName)) {
                currentNamedLayer = sf.createNamedLayer();
                currentName = sourceLayer;
                currentNamedLayer.setName(currentName);
                Style style = sf.createStyle();
                currentNamedLayer.styles().add(style);
                sld.layers().add(currentNamedLayer);
            }
            ((Style)currentNamedLayer.styles().get(0)).featureTypeStyles().addAll(featureTypeStyles);
        }
        if (background != null) {
            FilterFactory2 ff = this.parse.getFilterFactory();
            if (sld.getStyledLayers().length > 0) {
                MBLayer layer;
                layer = (NamedLayer)sld.getStyledLayers()[0];
                Style firstStyle = layer.getStyles()[0];
                firstStyle.setBackground(background.getFill(this));
            } else {
                this.addLoneBackgroundLayer((StyleFactory)sf, sld, background, ff);
            }
        } else if (sld.layers().isEmpty()) {
            throw new MBFormatException("No visibile layers");
        }
        sld.setName(this.getName());
        return sld;
    }

    private void addLoneBackgroundLayer(StyleFactory sf, StyledLayerDescriptor sld, BackgroundMBLayer background, FilterFactory2 ff) {
        UserLayer userLayer = sf.createUserLayer();
        Style style = sf.createStyle();
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        PrecisionModel pm = new PrecisionModel(PrecisionModel.FLOATING);
        GeometryFactory jtsFactory = new GeometryFactory(pm, 4326);
        try {
            CoordinateReferenceSystem crs = CRS.decode((String)"EPSG:4326");
            ftb.add("geometry", Polygon.class, crs);
            ftb.setCRS(crs);
            ftb.setDefaultGeometry("geometry");
            ftb.setName("background");
            SimpleFeatureType featureType = ftb.buildFeatureType();
            DefaultFeatureCollection fc = new DefaultFeatureCollection();
            fc.add(SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{jtsFactory.toGeometry((Envelope)new ReferencedEnvelope(CRS.getEnvelope((CoordinateReferenceSystem)crs)))}, (String)"background"));
            userLayer.setInlineFeatureType(featureType);
            userLayer.setInlineFeatureDatastore(DataUtilities.dataStore((SimpleFeatureCollection)fc));
            userLayer.setName("background");
            StyleBuilder sb = new StyleBuilder();
            Rule rule = sb.createRule((Symbolizer)sb.createPolygonSymbolizer());
            rule.setFilter((Filter)ff.equal((Expression)ff.literal(0), (Expression)ff.literal(1)));
            FeatureTypeStyle featureTypeStyle = sb.createFeatureTypeStyle("background", rule);
            style.featureTypeStyles().add(featureTypeStyle);
            style.setBackground(background.getFill(this));
            userLayer.userStyles().add(style);
            sld.layers().add(userLayer);
        }
        catch (FactoryException e) {
            throw new MBFormatException("Error constructing background layer", e);
        }
    }
}

