/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.mbstyle.function.ZoomLevelFunction;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.util.logging.Logging;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class MBObjectStops {
    static final Logger LOGGER = Logging.getLogger(MBObjectStops.class);
    private static final double ZOOM_EPS = 0.01;
    final JSONParser parser = new JSONParser();
    public LayerStops ls = new LayerStops();
    List<Double> layerZoomLevels;
    public List<Double> stops = new ArrayList<Double>();
    public List<MBLayer> layersForStop = new ArrayList<MBLayer>();
    public List<double[]> ranges = new ArrayList<double[]>();

    public MBObjectStops(MBLayer layer) {
        try {
            if (layer.getPaint() != null) {
                this.ls = this.getStops(layer.getPaint(), this.ls);
            }
            if (layer.getLayout() != null) {
                this.ls = this.getStops(layer.getLayout(), this.ls);
            }
            if (this.ls.zoomPropertyStops) {
                this.stops = this.getStopLevels(layer);
                this.layersForStop = this.getLayerStyleForStops(layer, this.stops);
                this.ranges = this.getStopLevelRanges(this.stops);
            }
        }
        catch (ParseException e) {
            LOGGER.log(Level.INFO, "Failed to parse MBStiles", e);
        }
    }

    public double getCurrentStop(MBLayer layer) {
        double stop = this.getStop(layer);
        return stop;
    }

    List<Double> getStopLevels(MBLayer mbLayer) {
        HashSet<Double> distinctValues = new HashSet<Double>();
        ArrayList<Double> zoomLevels = new ArrayList<Double>();
        this.layerZoomLevels = new ArrayList<Double>();
        if (mbLayer.getPaint() != null) {
            this.findStopLevels(mbLayer.getPaint(), this.layerZoomLevels);
        }
        if (mbLayer.getLayout() != null) {
            this.findStopLevels(mbLayer.getLayout(), this.layerZoomLevels);
        }
        distinctValues.addAll(this.layerZoomLevels);
        zoomLevels.addAll(distinctValues);
        Collections.sort(zoomLevels);
        return zoomLevels;
    }

    List<MBLayer> getLayerStyleForStops(MBLayer layer, List<Double> layerStops) throws ParseException {
        ArrayList<MBLayer> layers = new ArrayList<MBLayer>();
        for (int i = 0; i < layerStops.size(); ++i) {
            JSONObject obj = (JSONObject)this.parser.parse(layer.getJson().toJSONString());
            MBLayer workingLayer = MBLayer.create(obj);
            Double maxZoom = layerStops.get(layerStops.size() - 1);
            Double current = layerStops.get(i);
            double[] range = new double[]{0.0, 0.0};
            if (current < maxZoom) {
                range[0] = current;
                range[1] = layerStops.get(i + 1);
            } else if (current.equals(maxZoom)) {
                range[0] = current;
                range[1] = maxZoom;
            }
            layers.add(this.createLayerStopStyle(workingLayer, range));
        }
        return layers;
    }

    List<double[]> getStopLevelRanges(List<Double> stops) {
        ArrayList<double[]> ranges = new ArrayList<double[]>();
        for (int i = 0; i < stops.size(); ++i) {
            Double maxZoom = stops.get(stops.size() - 1);
            Double current = stops.get(i);
            double[] range = new double[]{0.0, 0.0};
            if (current < maxZoom) {
                range[0] = current;
                range[1] = stops.get(i + 1);
            } else if (current.equals(maxZoom)) {
                range[0] = current;
                range[1] = -1.0;
            }
            ranges.add(range);
        }
        return ranges;
    }

    LayerStops getStops(JSONObject jsonObject, LayerStops ls) {
        return this.containsStops(jsonObject, ls);
    }

    public double[] getRangeForStop(Double stop, List<double[]> ranges) {
        double[] rangeForStopLevel = new double[]{0.0, 0.0};
        for (double[] range : ranges) {
            if (range[0] != stop) continue;
            rangeForStopLevel = range;
        }
        return rangeForStopLevel;
    }

    public static Double zoomLevelToScaleDenominator(double zoomLevel) {
        return ZoomLevelFunction.EPSG_3857_O_SCALE / Math.pow(2.0, zoomLevel);
    }

    public double getStop(MBLayer layer) {
        return this.stop(layer);
    }

    LayerStops containsStops(JSONObject jsonObject, LayerStops ls) {
        Set keySet = jsonObject.keySet();
        for (Object o : keySet) {
            JSONObject child;
            String key = (String)o;
            if (!(jsonObject.get((Object)key) instanceof JSONObject) || !(child = (JSONObject)jsonObject.get((Object)key)).containsKey((Object)"stops")) continue;
            if (child.containsKey((Object)"property")) {
                JSONArray stops = (JSONArray)child.get((Object)"stops");
                JSONArray stopObject = (JSONArray)stops.get(0);
                if (stopObject.get(0) instanceof JSONObject) {
                    ls.zoomPropertyStops = true;
                    continue;
                }
                ls.propertyStops = true;
                continue;
            }
            if (child.containsKey((Object)"property")) continue;
            ls.zoomStops = true;
        }
        return ls;
    }

    double stop(MBLayer layer) {
        double s = 0.0;
        if (layer.getPaint() != null) {
            s = this.findStop(layer.getPaint(), s);
        }
        if (layer.getLayout() != null) {
            s = this.findStop(layer.getLayout(), s);
        }
        return s;
    }

    MBLayer createLayerStopStyle(MBLayer layer, double[] range) {
        if (layer.getPaint() != null) {
            this.reduceJsonForRange(layer.getPaint(), range);
        }
        if (layer.getLayout() != null) {
            this.reduceJsonForRange(layer.getLayout(), range);
        }
        return layer;
    }

    double findStop(JSONObject jsonObject, double layerStop) {
        Set keySet = jsonObject.keySet();
        for (Object value : keySet) {
            JSONObject child;
            String key = (String)value;
            if (!(jsonObject.get((Object)key) instanceof JSONObject) || !(child = (JSONObject)jsonObject.get((Object)key)).containsKey((Object)"stops")) continue;
            JSONArray stops = (JSONArray)child.get((Object)"stops");
            for (Object o : stops) {
                JSONArray stop = (JSONArray)o;
                if (!(stop.get(0) instanceof Number)) continue;
                layerStop = ((Number)stop.get(0)).doubleValue();
            }
        }
        return layerStop;
    }

    JSONObject reduceJsonForRange(JSONObject jsonObject, double[] range) {
        Set keySet = jsonObject.keySet();
        Iterator keys = keySet.iterator();
        ArrayList<String> keyToRemove = new ArrayList<String>();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (!(jsonObject.get((Object)key) instanceof JSONObject)) continue;
            JSONObject child = (JSONObject)jsonObject.get((Object)key);
            if (child.containsKey((Object)"stops")) {
                ArrayList<JSONArray> objectsToEdit = new ArrayList<JSONArray>();
                ArrayList objectsToRemove = new ArrayList();
                JSONArray stops = (JSONArray)child.get((Object)"stops");
                for (Object e : stops) {
                    double zoomValue;
                    JSONArray stop = (JSONArray)e;
                    if (stop.get(0) instanceof JSONObject) {
                        zoomValue = ((Number)((JSONObject)stop.get(0)).get((Object)"zoom")).doubleValue();
                        if (this.zoomEquals(zoomValue, range[0])) {
                            objectsToEdit.add((JSONArray)e);
                        } else {
                            objectsToRemove.add(e);
                        }
                    }
                    if (!(stop.get(0) instanceof Number)) continue;
                    zoomValue = ((Number)stop.get(0)).doubleValue();
                    if (this.zoomEquals(zoomValue, range[0])) {
                        objectsToEdit.add((JSONArray)e);
                        continue;
                    }
                    objectsToRemove.add(e);
                }
                for (Object e : objectsToRemove) {
                    stops.remove(e);
                }
                for (JSONArray jSONArray : objectsToEdit) {
                    JSONArray stopsArray = new JSONArray();
                    if (jSONArray.get(0) instanceof JSONObject) {
                        stopsArray.add(0, ((JSONObject)jSONArray.get(0)).get((Object)"value"));
                        stopsArray.add(1, jSONArray.get(1));
                        stops.remove((Object)jSONArray);
                        stops.add((Object)stopsArray);
                    }
                    if (!(jSONArray.get(0) instanceof Number)) continue;
                    stopsArray.add(0, (Object)((Number)jSONArray.get(0)).doubleValue());
                    stopsArray.add(1, jSONArray.get(1));
                    stops.remove((Object)jSONArray);
                    stops.add((Object)stopsArray);
                }
            }
            if (((JSONArray)child.get((Object)"stops")).size() != 0) continue;
            keyToRemove.add(key);
        }
        for (String key : keyToRemove) {
            jsonObject.remove((Object)key);
        }
        return jsonObject;
    }

    private boolean zoomEquals(double d1, double d2) {
        return Math.abs(d1 - d2) < 0.01;
    }

    List<Double> findStopLevels(JSONObject jsonObject, List<Double> layerZoomLevels) {
        Set keySet = jsonObject.keySet();
        for (Object value : keySet) {
            JSONObject child;
            String key = (String)value;
            if (!(jsonObject.get((Object)key) instanceof JSONObject) || !(child = (JSONObject)jsonObject.get((Object)key)).containsKey((Object)"stops")) continue;
            JSONArray stops = (JSONArray)child.get((Object)"stops");
            for (Object o : stops) {
                JSONArray stop = (JSONArray)o;
                if (stop.get(0) instanceof Number) {
                    layerZoomLevels.add(((Number)stop.get(0)).doubleValue());
                    continue;
                }
                if (stop.get(0) instanceof JSONObject) {
                    layerZoomLevels.add(((Number)((JSONObject)stop.get(0)).get((Object)"zoom")).doubleValue());
                    continue;
                }
                throw new MBFormatException("The \"property\" field missing for stops or invalid zoom.");
            }
        }
        return layerZoomLevels;
    }

    public static class LayerStops {
        public boolean propertyStops = false;
        public boolean zoomStops = false;
        public boolean zoomPropertyStops = false;

        public boolean isPropertyStops() {
            return this.propertyStops;
        }

        public void setPropertyStops(boolean propertyStops) {
            this.propertyStops = propertyStops;
        }

        public boolean isZoomStops() {
            return this.zoomStops;
        }

        public void setZoomStops(boolean zoomStops) {
            this.zoomStops = zoomStops;
        }

        public boolean isZoomPropertyStops() {
            return this.zoomPropertyStops;
        }

        public void setZoomPropertyStops(boolean zoomPropertyStops) {
            this.zoomPropertyStops = zoomPropertyStops;
        }

        public boolean hasStops() {
            return this.zoomPropertyStops || this.propertyStops || this.zoomStops;
        }
    }
}

