/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.layer;

import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.geotools.mbstyle.MBStyle;
import org.geotools.mbstyle.layer.MBLayer;
import org.geotools.mbstyle.parse.MBFilter;
import org.geotools.mbstyle.parse.MBFormatException;
import org.geotools.mbstyle.parse.MBObjectParser;
import org.geotools.measure.Units;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.text.Text;
import org.json.simple.JSONObject;
import org.opengis.filter.expression.Expression;
import org.opengis.style.Description;
import org.opengis.style.Displacement;
import org.opengis.style.Fill;
import org.opengis.style.SemanticType;

public class CircleMBLayer
extends MBLayer {
    private final JSONObject paint = this.paint();
    private static final String TYPE = "circle";

    public CircleMBLayer(JSONObject json) {
        super(json, new MBObjectParser(CircleMBLayer.class));
    }

    @Override
    protected SemanticType defaultSemanticType() {
        return SemanticType.POINT;
    }

    public Number getCircleRadius() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "circle-radius", 5.0);
    }

    public Expression circleRadius() throws MBFormatException {
        return this.parse.percentage(this.paint, "circle-radius", 5);
    }

    public Color getCircleColor() throws MBFormatException {
        return this.parse.optional(Color.class, this.paint, "circle-color", Color.BLACK);
    }

    public Expression circleColor() throws MBFormatException {
        return this.parse.color(this.paint, "circle-color", Color.BLACK);
    }

    public Number getCircleBlur() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "circle-blur", 0.0);
    }

    public Expression circleBlur() throws MBFormatException {
        return this.parse.percentage(this.paint, "circle-blur", 0);
    }

    public Number getCircleOpacity() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "circle-opacity", 1.0);
    }

    public Expression circleOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "circle-opacity", 1);
    }

    public int[] getCircleTranslate() throws MBFormatException {
        return this.parse.array(this.paint, "circle-translate", new int[]{0, 0});
    }

    public Point circleTranslate() throws MBFormatException {
        int[] circleTranslate = this.getCircleTranslate();
        return new Point(circleTranslate[0], circleTranslate[1]);
    }

    public Displacement circleTranslateDisplacement() {
        return this.parse.displacement(this.paint, "circle-translate", this.sf.displacement((Expression)this.ff.literal(0), (Expression)this.ff.literal(0)));
    }

    public CircleTranslateAnchor getCircleTranslateAnchor() {
        Object value = this.paint.get((Object)"circle-translate-anchor");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return CircleTranslateAnchor.VIEWPORT;
        }
        return CircleTranslateAnchor.MAP;
    }

    public CirclePitchScale getCirclePitchScale() {
        Object value = this.paint.get((Object)"circle-pitch-scale");
        if (value != null && "viewport".equalsIgnoreCase((String)value)) {
            return CirclePitchScale.VIEWPORT;
        }
        return CirclePitchScale.MAP;
    }

    public Number getCircleStrokeWidth() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "circle-stroke-width", 0.0);
    }

    public Expression circleStrokeWidth() throws MBFormatException {
        return this.parse.percentage(this.paint, "circle-stroke-width", 0);
    }

    public Color getCircleStrokeColor() throws MBFormatException {
        return this.parse.optional(Color.class, this.paint, "circle-stroke-color", Color.BLACK);
    }

    public Expression circleStrokeColor() throws MBFormatException {
        return this.parse.color(this.paint, "circle-stroke-color", Color.BLACK);
    }

    public Number getCircleStrokeOpacity() throws MBFormatException {
        return this.parse.optional(Double.class, this.paint, "circle-stroke-opacity", 1.0);
    }

    public Expression circleStrokeOpacity() throws MBFormatException {
        return this.parse.percentage(this.paint, "circle-stroke-opacity", 1);
    }

    @Override
    public List<FeatureTypeStyle> transformInternal(MBStyle styleContext) {
        Stroke s = this.sf.stroke(this.circleStrokeColor(), this.circleStrokeOpacity(), this.circleStrokeWidth(), null, Stroke.DEFAULT.getLineCap(), null, null);
        org.geotools.styling.Fill f = this.sf.fill(null, this.circleColor(), this.circleOpacity());
        Mark m = this.sf.mark((Expression)this.ff.literal((Object)TYPE), (Fill)f, (org.opengis.style.Stroke)s);
        Graphic gr = this.sf.graphic(Arrays.asList(m), null, (Expression)this.ff.multiply((Expression)this.ff.literal(2), this.circleRadius()), null, null, this.circleTranslateDisplacement());
        gr.graphicalSymbols().clear();
        gr.graphicalSymbols().add(m);
        PointSymbolizer ps = this.sf.pointSymbolizer(this.getId(), (Expression)this.ff.property((String)null), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), Units.PIXEL, (org.opengis.style.Graphic)gr);
        MBFilter filter = this.getFilter();
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Rule rule = this.sf.rule(this.getId(), null, null, 0.0, Double.POSITIVE_INFINITY, Arrays.asList(ps), filter.filter());
        rules.add(rule);
        return Collections.singletonList(this.sf.featureTypeStyle(this.getId(), (Description)this.sf.description(Text.text((String)("MBStyle " + this.getId())), Text.text((String)("Generated for " + this.getSourceLayer()))), null, Collections.emptySet(), filter.semanticTypeIdentifiers(), rules));
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public static enum CirclePitchScale {
        MAP,
        VIEWPORT;

    }

    public static enum CircleTranslateAnchor {
        MAP,
        VIEWPORT;

    }
}

