/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;

public class ZoomLevelFunction
extends FunctionExpressionImpl {
    public static final FunctionName NAME = new FunctionNameImpl("zoomLevel", FunctionNameImpl.parameter((String)"zoomLevel", Number.class), new Parameter[]{FunctionNameImpl.parameter((String)"scaleDenominator", Number.class), FunctionNameImpl.parameter((String)"srid", String.class)});
    public static final String MBSTYLE_ROOT_TILE_PIXELS_KEY = "MBSTYLE_ROOT_TILE_PIXELS";
    public static final int ROOT_TILE_PIXELS = Integer.parseInt(System.getProperty("MBSTYLE_ROOT_TILE_PIXELS", "512"));
    public static final double EPSG_3857_O_SCALE = 5.590822639508929E8 / (double)ROOT_TILE_PIXELS * 256.0;

    public ZoomLevelFunction() {
        super(NAME);
    }

    public int getArgCount() {
        return 2;
    }

    public Object evaluate(Object feature) {
        String arg1;
        Number arg0;
        try {
            arg0 = (Number)this.getExpression(0).evaluate(feature, Number.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function zoomLevel argument #0 - expected Number", e);
        }
        try {
            arg1 = (String)this.getExpression(1).evaluate(feature, String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function zoomLevel argument #1 - expected String", e);
        }
        if ("EPSG:3857".equals(arg1)) {
            return Math.log(EPSG_3857_O_SCALE / arg0.doubleValue()) / Math.log(2.0);
        }
        throw new IllegalArgumentException("Unsupported srid for zoomLevel function: " + arg1);
    }
}

