/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.mbstyle.layer.SymbolMBLayer;
import org.opengis.filter.capability.FunctionName;
import org.opengis.parameter.Parameter;

public class MapBoxAnchorFunction
extends FunctionExpressionImpl {
    public static final FunctionName NAME = new FunctionNameImpl("mbAnchor", FunctionNameImpl.parameter((String)"anchorPercentage", Double.class), new Parameter[]{FunctionNameImpl.parameter((String)"anchorName", String.class, (int)1, (int)1), FunctionNameImpl.parameter((String)"axis", String.class, (int)1, (int)1)});

    protected MapBoxAnchorFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        SymbolMBLayer.TextAnchor anchor;
        try {
            anchor = SymbolMBLayer.TextAnchor.parse((String)this.getExpression(0).evaluate(object, String.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function \"mbAnchor\" argument #0 - expected anchor name, one of: " + Stream.of(SymbolMBLayer.TextAnchor.values()).map(Enum::name).collect(Collectors.joining()));
        }
        Axis axis = Axis.parse((String)this.getExpression(1).evaluate(object, String.class));
        return axis.evaluate(anchor);
    }

    static enum Axis {
        x{

            @Override
            Double evaluate(SymbolMBLayer.TextAnchor anchor) {
                return anchor.getX();
            }
        }
        ,
        y{

            @Override
            Double evaluate(SymbolMBLayer.TextAnchor anchor) {
                return anchor.getY();
            }
        };


        static Axis parse(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Axis should be either x or y");
            }
            return Axis.valueOf(name.toLowerCase());
        }

        abstract Double evaluate(SymbolMBLayer.TextAnchor var1);
    }
}

