/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.function;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.Parameter;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.text.Text;
import org.geotools.util.Converters;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;

public class ExponentialFunction
extends FunctionImpl {
    private static final FilterFactory2 ff2 = CommonFactoryFinder.getFilterFactory2(null);
    public static final FunctionName NAME;

    public ExponentialFunction() {
        this.functionName = NAME;
    }

    public Object evaluate(Object object) {
        List<Stop> stops = this.getStops(this.getParameters());
        Class target = Color.class;
        for (Stop stop : stops) {
            if (stop.value.evaluate(object, Double.class) == null) continue;
            target = Double.class;
        }
        return this.evaluate(object, target);
    }

    public <T> T evaluate(Object object, Class<T> context) {
        List parameters = this.getParameters();
        Expression input = (Expression)parameters.get(0);
        Expression base = (Expression)parameters.get(1);
        List<Stop> stops = this.getStops(parameters);
        Double inputValue = (Double)input.evaluate(object, Double.class);
        Double baseValue = (Double)base.evaluate(object, Double.class);
        if (inputValue == null) {
            return null;
        }
        if (stops.size() == 1) {
            Stop single = stops.get(0);
            return (T)single.value.evaluate(object, context);
        }
        int find = this.find(object, inputValue, stops);
        if (find <= 0) {
            Stop min = stops.get(0);
            return (T)min.value.evaluate(object, context);
        }
        if (find >= stops.size()) {
            Stop max = stops.get(stops.size() - 1);
            return (T)max.value.evaluate(object, context);
        }
        Stop lower = stops.get(find - 1);
        Stop upper = stops.get(find);
        Object exponential = this.exponential(object, inputValue, baseValue, lower, upper, context);
        return (T)Converters.convert((Object)exponential, context);
    }

    public List<Stop> getStops(List<Expression> parameters) {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        if (parameters.size() % 2 != 0) {
            throw new IllegalArgumentException(((Object)((Object)this)).getClass().getSimpleName() + " requires an even number of stop values, but " + (parameters.size() - 2) + " were provided.");
        }
        int i = 2;
        while (i + 1 < parameters.size()) {
            Stop stop = new Stop(parameters.get(i), parameters.get(i + 1));
            stops.add(stop);
            i += 2;
        }
        return stops;
    }

    private <T> Object exponential(Object object, double inputValue, double base, Stop lower, Stop upper, Class<T> context) {
        if (Color.class.isAssignableFrom(context)) {
            return this.colorExponential(object, inputValue, base, lower, upper);
        }
        return this.numericExponential(object, inputValue, base, lower, upper);
    }

    private double numericExponential(Object object, double inputValue, double base, Stop lower, Stop upper) {
        double stop1 = (Double)lower.stop.evaluate(object, Double.class);
        double value1 = (Double)lower.value.evaluate(object, Double.class);
        double stop2 = (Double)upper.stop.evaluate(object, Double.class);
        double value2 = (Double)upper.value.evaluate(object, Double.class);
        double t = this.exponentialInterpolationRatio(object, inputValue, base, stop1, stop2);
        return value1 * (1.0 - t) + value2 * t;
    }

    private double exponentialInterpolationRatio(Object object, double inputValue, double base, double stop1, double stop2) {
        double difference = stop2 - stop1;
        double progress = inputValue - stop1;
        if (difference == 0.0) {
            return 0.0;
        }
        if (base == 1.0) {
            return progress / difference;
        }
        return (Math.pow(base, progress) - 1.0) / (Math.pow(base, difference) - 1.0);
    }

    private Object colorExponential(Object object, double inputValue, double base, Stop lower, Stop upper) {
        Color lowerValue = (Color)lower.value.evaluate(object, Color.class);
        Color upperValue = (Color)upper.value.evaluate(object, Color.class);
        Stop redLowerStop = new Stop(lower.stop, (Expression)ff2.literal(lowerValue.getRed()));
        Stop redUpperStop = new Stop(upper.stop, (Expression)ff2.literal(upperValue.getRed()));
        Stop greenLowerStop = new Stop(lower.stop, (Expression)ff2.literal(lowerValue.getGreen()));
        Stop greenUpperStop = new Stop(upper.stop, (Expression)ff2.literal(upperValue.getGreen()));
        Stop blueLowerStop = new Stop(lower.stop, (Expression)ff2.literal(lowerValue.getBlue()));
        Stop blueUpperStop = new Stop(upper.stop, (Expression)ff2.literal(upperValue.getBlue()));
        Stop alphaLowerStop = new Stop(lower.stop, (Expression)ff2.literal(lowerValue.getAlpha()));
        Stop alphaUpperStop = new Stop(upper.stop, (Expression)ff2.literal(upperValue.getAlpha()));
        double r = this.numericExponential(object, inputValue, base, redLowerStop, redUpperStop);
        double g = this.numericExponential(object, inputValue, base, greenLowerStop, greenUpperStop);
        double b = this.numericExponential(object, inputValue, base, blueLowerStop, blueUpperStop);
        double a = this.numericExponential(object, inputValue, base, alphaLowerStop, alphaUpperStop);
        return new Color((int)Math.round(r), (int)Math.round(g), (int)Math.round(b), (int)Math.round(a));
    }

    private int find(Object object, Double input, List<Stop> stops) {
        int find = stops.size();
        for (int i = 0; i < stops.size(); ++i) {
            Double stop = (Double)stops.get((int)i).stop.evaluate(object, Double.class);
            if (!(input <= stop)) continue;
            find = i;
            break;
        }
        return find;
    }

    static {
        Parameter result = new Parameter("result", Object.class, 1, 1);
        Parameter input = new Parameter("input", Object.class, 1, 1);
        Parameter base = new Parameter("base", Double.class, Text.text((String)"Base"), Text.text((String)"Exponential base of the interpolation curve controlling rate at which function output increases."), true, 0, 1, (Object)1.0, null);
        Parameter stops = new Parameter("stops", Object.class, 4, -1);
        NAME = new FunctionNameImpl("Exponential", (org.opengis.parameter.Parameter)result, new org.opengis.parameter.Parameter[]{input, base, stops});
    }

    private static class Stop {
        final Expression stop;
        final Expression value;

        public Stop(Expression stop, Expression value) {
            this.stop = stop;
            this.value = value;
        }

        public String toString() {
            return "Stop " + String.valueOf(this.stop) + ": " + String.valueOf(this.value);
        }
    }
}

