/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;
import org.opengis.filter.expression.Expression;

public class MBLookup
extends MBExpression {
    public MBLookup(JSONArray json) {
        super(json);
    }

    public Expression lookupAt() {
        if (this.json.size() == 3 && this.parse.string(this.json, 2) != null) {
            Expression e = this.parse.string(this.json, 2);
            Expression at = this.parse.string(this.json, 1);
            return this.ff.function("at", new Expression[]{e, at});
        }
        throw new MBFormatException("The \"at\" expression requires an integer value at index 1, and a literal array value at index 2");
    }

    public Expression lookupGet() {
        if (this.json.size() == 2) {
            if (this.parse.isString(this.json, 1)) {
                String propertyName = this.parse.get(this.json, 1);
                return this.ff.property(propertyName);
            }
            Expression property = this.parse.string(this.json, 1);
            return this.ff.function("property", new Expression[]{property});
        }
        if (this.json.size() == 3) {
            Expression value = this.parse.string(this.json, 1);
            Expression object = this.parse.string(this.json, 2);
            return this.ff.function("get", new Expression[]{value, object});
        }
        throw new MBFormatException("Data expression \"get\" requires a maximum of 3 arguments.");
    }

    public Expression lookupHas() {
        if (this.json.size() == 2) {
            Expression value = this.parse.string(this.json, 1);
            return this.ff.function("PropertyExists", new Expression[]{value});
        }
        if (this.json.size() == 3) {
            Expression value = this.parse.string(this.json, 1);
            Expression object = this.parse.string(this.json, 2);
            return this.ff.function("has", new Expression[]{value, object});
        }
        throw new MBFormatException("Expression \"has\" requires 1 or 2 arguments " + this.json.size() + " arguments found");
    }

    public Expression lookupLength() {
        Expression e = this.parse.string(this.json, 1);
        return this.ff.function("mbLength", new Expression[]{e});
    }

    @Override
    public Expression getExpression() throws MBFormatException {
        switch (this.name) {
            case "at": {
                return this.lookupAt();
            }
            case "get": {
                return this.lookupGet();
            }
            case "has": {
                return this.lookupHas();
            }
            case "length": {
                return this.lookupLength();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported lookup expression");
    }
}

