/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;
import org.opengis.filter.expression.Expression;

public class MBDecision
extends MBExpression {
    private static final String NOT = "!";
    private static final String NOT_EQUALS = "!=";
    private static final String LESS_THAN = "<";
    private static final String LESS_THAN_EQUALS = "<=";
    private static final String EQUALS = "==";
    private static final String GREATER_THAN = ">";
    private static final String GREATER_THAN_EQUALS = ">=";
    private static final String ALL = "all";
    private static final String ANY = "any";
    private static final String CASE = "case";
    private static final String COALESCE = "coalesce";
    private static final String MATCH = "match";

    public MBDecision(JSONArray json) {
        super(json);
    }

    private Expression decisionNot() {
        if (this.json.size() != 2) {
            this.throwUnexpectedArgumentCount(NOT, 1);
        }
        Expression boolArg = this.parse.string(this.json, 1);
        return this.ff.function("not", new Expression[]{boolArg});
    }

    private Expression decisionNotEqual() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(NOT_EQUALS, 2);
        }
        Expression comparable1 = this.parse.string(this.json, 1);
        Expression comparable2 = this.parse.string(this.json, 2);
        return this.ff.function("mbNotEqualTo", new Expression[]{comparable1, comparable2});
    }

    private Expression decisionLessThan() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(LESS_THAN, 2);
        }
        Expression firstArgument = this.parse.string(this.json, 1);
        Expression secondArgument = this.parse.string(this.json, 2);
        return this.ff.function("lessThan", new Expression[]{firstArgument, secondArgument});
    }

    private Expression decisionLessEqualThan() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(LESS_THAN_EQUALS, 2);
        }
        Expression firstArgument = this.parse.string(this.json, 1);
        Expression secondArgument = this.parse.string(this.json, 2);
        return this.ff.function("lessEqualThan", new Expression[]{firstArgument, secondArgument});
    }

    private Expression decisionEqualTo() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(EQUALS, 2);
        }
        Expression comparable1 = this.parse.string(this.json, 1);
        Expression comparable2 = this.parse.string(this.json, 2);
        return this.ff.function("mbEqualTo", new Expression[]{comparable1, comparable2});
    }

    private Expression decisionGreaterThan() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(GREATER_THAN, 2);
        }
        Expression firstArgument = this.parse.string(this.json, 1);
        Expression secondArgument = this.parse.string(this.json, 2);
        return this.ff.function("greaterThan", new Expression[]{firstArgument, secondArgument});
    }

    private Expression decisionGreaterEqualThan() {
        if (this.json.size() != 3) {
            this.throwUnexpectedArgumentCount(GREATER_THAN_EQUALS, 2);
        }
        Expression firstArgument = this.parse.string(this.json, 1);
        Expression secondArgument = this.parse.string(this.json, 2);
        return this.ff.function("greaterEqualThan", new Expression[]{firstArgument, secondArgument});
    }

    private Expression decisionAll() {
        if (this.json.size() < 2) {
            this.throwInsufficientArgumentCount(ALL, 1);
        }
        Expression[] expressions = new Expression[this.json.size() - 1];
        for (int i = 1; i < this.json.size(); ++i) {
            Expression expression;
            expressions[i - 1] = expression = this.parse.string(this.json, i);
        }
        return this.ff.function(ALL, expressions);
    }

    private Expression decisionAny() {
        if (this.json.size() < 2) {
            this.throwInsufficientArgumentCount(ANY, 1);
        }
        Expression[] expressions = new Expression[this.json.size() - 1];
        for (int i = 1; i < this.json.size(); ++i) {
            Expression expression;
            expressions[i - 1] = expression = this.parse.string(this.json, i);
        }
        return this.ff.function(ANY, expressions);
    }

    private Expression decisionCase() {
        if (this.json.size() < 3) {
            this.throwInsufficientArgumentCount(ALL, 2);
        }
        Expression[] expressions = new Expression[this.json.size() - 1];
        for (int i = 1; i < this.json.size(); ++i) {
            Expression expression;
            expressions[i - 1] = expression = this.parse.string(this.json, i);
        }
        return this.ff.function(CASE, expressions);
    }

    private Expression decisionCoalesce() {
        if (this.json.size() < 2) {
            this.throwInsufficientArgumentCount(COALESCE, 1);
        }
        Expression[] expressions = new Expression[this.json.size() - 1];
        for (int i = 1; i < this.json.size(); ++i) {
            Expression expression;
            expressions[i - 1] = expression = this.parse.string(this.json, i);
        }
        return this.ff.function(COALESCE, expressions);
    }

    private Expression decisionMatch() {
        if (this.json.size() < 4) {
            this.throwInsufficientArgumentCount(COALESCE, 3);
        }
        Expression[] expressions = new Expression[this.json.size() - 1];
        for (int i = 1; i < this.json.size(); ++i) {
            Expression expression;
            expressions[i - 1] = expression = this.parse.string(this.json, i);
        }
        return this.ff.function(MATCH, expressions);
    }

    @Override
    public Expression getExpression() throws MBFormatException {
        switch (this.name) {
            case "!": {
                return this.decisionNot();
            }
            case "!=": {
                return this.decisionNotEqual();
            }
            case "<": {
                return this.decisionLessThan();
            }
            case "<=": {
                return this.decisionLessEqualThan();
            }
            case "==": {
                return this.decisionEqualTo();
            }
            case ">": {
                return this.decisionGreaterThan();
            }
            case ">=": {
                return this.decisionGreaterEqualThan();
            }
            case "all": {
                return this.decisionAll();
            }
            case "any": {
                return this.decisionAny();
            }
            case "case": {
                return this.decisionCase();
            }
            case "coalesce": {
                return this.decisionCoalesce();
            }
            case "match": {
                return this.decisionMatch();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported decision expression");
    }
}

