/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.mbstyle.expression;

import org.geotools.mbstyle.expression.MBExpression;
import org.geotools.mbstyle.parse.MBFormatException;
import org.json.simple.JSONArray;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;

public class MBColor
extends MBExpression {
    public MBColor(JSONArray json) {
        super(json);
    }

    public Expression colorRGB() {
        if (this.json.size() == 4) {
            Expression er = this.parse.string(this.json, 1);
            er = this.transformLiteral(er);
            Function roundR = this.ff.function("round_2", new Expression[]{er});
            Expression eg = this.parse.string(this.json, 2);
            eg = this.transformLiteral(eg);
            Function roundG = this.ff.function("round_2", new Expression[]{eg});
            Expression eb = this.parse.string(this.json, 3);
            eb = this.transformLiteral(eb);
            Function roundB = this.ff.function("round_2", new Expression[]{eb});
            return this.ff.function("torgb", new Expression[]{roundR, roundG, roundB});
        }
        throw new MBFormatException("Expression \"rgb\" requires exactly 3 arguments");
    }

    public Expression colorRGBA() {
        throw new UnsupportedOperationException("RGBA colors are currently unsupported");
    }

    public Expression colorToRGBA() {
        throw new UnsupportedOperationException("RGBA colors are currently unsupported.");
    }

    @Override
    public Expression getExpression() throws MBFormatException {
        switch (this.name) {
            case "rgb": {
                return this.colorRGB();
            }
            case "rgba": {
                return this.colorRGBA();
            }
            case "to-rgba": {
                return this.colorToRGBA();
            }
        }
        throw new MBFormatException(this.name + " is an unsupported color expression");
    }
}

