/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.NameImpl;

public final class CollectionSource<T> {
    private Collection<T> collection;
    private CoordinateReferenceSystem crs;

    public CollectionSource(Collection<T> collection) {
        this(collection, null);
    }

    public CollectionSource(Collection<T> collection, CoordinateReferenceSystem crs) {
        this.collection = Collections.unmodifiableCollection(collection);
        this.crs = crs;
    }

    public Collection<T> content() {
        return this.collection;
    }

    public Collection<T> content(String query, String queryLanguage) {
        throw new UnsupportedOperationException("Please help me hook up the parser!");
    }

    public Collection<T> content(Filter filter) {
        return this.content(filter, Integer.MAX_VALUE);
    }

    public Collection<T> content(Filter filter, int countLimit) {
        ArrayList<T> list = new ArrayList<T>();
        int count = 0;
        Iterator<T> i = this.collection.iterator();
        while (i.hasNext() && count < countLimit) {
            T obj = i.next();
            if (!filter.evaluate(obj)) continue;
            list.add(obj);
            ++count;
        }
        return Collections.unmodifiableList(list);
    }

    public Object describe() {
        return Object.class;
    }

    public void dispose() {
        this.collection = null;
    }

    public FilterCapabilities getFilterCapabilities() {
        return null;
    }

    public Name getName() {
        return new NameImpl("localhost/memory");
    }

    public void setTransaction(Transaction t) {
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }
}

