/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import java.util.Calendar;
import java.util.Date;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Position;
import org.geotools.api.temporal.RelativePosition;
import org.geotools.api.temporal.TemporalPrimitive;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTemporalPrimitiveTest {
    private TemporalPrimitive temporalPrimitive1;
    private TemporalPrimitive temporalPrimitive2;
    private Position position1;
    private Position position2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        this.cal.set(1981, 6, 25);
        Date date = this.cal.getTime();
        this.position1 = new DefaultPosition(date);
        this.position2 = new DefaultPosition(new Date());
        this.temporalPrimitive1 = new DefaultInstant(this.position1);
        this.temporalPrimitive2 = new DefaultInstant(this.position2);
    }

    @After
    public void tearDown() {
        this.position1 = null;
        this.position2 = null;
        this.temporalPrimitive1 = null;
        this.temporalPrimitive2 = null;
    }

    @Test
    public void testRelativePosition() {
        this.cal.set(2000, 0, 1);
        DefaultPosition position = new DefaultPosition(this.cal.getTime());
        DefaultInstant other = new DefaultInstant((Position)position);
        RelativePosition result = this.temporalPrimitive1.relativePosition((TemporalPrimitive)other);
        Assert.assertNotEquals((Object)this.temporalPrimitive2.relativePosition((TemporalPrimitive)other), (Object)result);
        DefaultInstant instant1 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        DefaultInstant instant2 = (DefaultInstant)this.temporalPrimitive2;
        other = new DefaultPeriod((Instant)instant1, (Instant)instant2);
        result = this.temporalPrimitive1.relativePosition((TemporalPrimitive)other);
        Assert.assertNotEquals((Object)this.temporalPrimitive2.relativePosition((TemporalPrimitive)other), (Object)result);
        this.temporalPrimitive1 = new DefaultPeriod((Instant)new DefaultInstant(this.position1), (Instant)instant1);
        this.cal.set(2200, 9, 1);
        this.temporalPrimitive2 = new DefaultPeriod((Instant)instant2, (Instant)new DefaultInstant((Position)new DefaultPosition(this.cal.getTime())));
        result = this.temporalPrimitive1.relativePosition((TemporalPrimitive)other);
        Assert.assertNotEquals((Object)this.temporalPrimitive2.relativePosition((TemporalPrimitive)other), (Object)result);
    }
}

