/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.HashMap;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.WKTReader;

public class WrappingProjectionHandlerTest {
    final GeometryFactory gf = new GeometryFactory();
    final WKTReader wktReader = new WKTReader();

    @Test
    public void testAccumulateWithDifferentGeometryTypes() throws Exception {
        ArrayList resultGeoms = new ArrayList();
        Geometry point = this.wktReader.read("POINT(1 1)");
        Geometry line = this.wktReader.read("LINESTRING(1 1, 1 2, 2 2)");
        GeometryCollection collection = new GeometryCollection(new Geometry[]{point, line}, this.gf);
        ReferencedEnvelope envelope = new ReferencedEnvelope(0.0, 5.0, 0.0, 5.0, CRS.decode((String)"EPSG:4326"));
        Class resultClass = WrappingProjectionHandler.accumulate(resultGeoms, (Geometry)collection, null, (ReferencedEnvelope)envelope);
        Assert.assertEquals(Geometry.class, (Object)resultClass);
    }

    @Test
    public void testPreFlipped() throws Exception {
        DefaultGeographicCRS WGS84 = DefaultGeographicCRS.WGS84;
        ReferencedEnvelope world = new ReferencedEnvelope(-180.0, 180.0, -40.0, 40.0, (CoordinateReferenceSystem)WGS84);
        CoordinateReferenceSystem MERCATOR = CRS.decode((String)"EPSG:3395", (boolean)true);
        ReferencedEnvelope mercatorEnvelope = world.transform(MERCATOR, true);
        mercatorEnvelope.translate(mercatorEnvelope.getWidth() / 2.0, 0.0);
        Geometry polygon = this.wktReader.read("MultiPolygon (((179.62477969 52.46819975, 179.51039918 52.20137203, 179.94028987 52.14290407, -179.9428079 52.40938205, 179.62477969 52.46819975)))");
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("datelineWrappingCheckEnabled", true);
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)WGS84, (CoordinateReferenceSystem)MERCATOR, (boolean)true);
        Geometry reprojected = JTS.transform((Geometry)polygon, (MathTransform)mt);
        ProjectionHandler handler = ProjectionHandlerFinder.getHandler((ReferencedEnvelope)mercatorEnvelope, (CoordinateReferenceSystem)WGS84, (boolean)true, params);
        Geometry preProcessed = handler.preProcess(polygon);
        Assert.assertEquals((Object)"PRE-FLIPPED", (Object)preProcessed.getUserData());
        reprojected.setUserData((Object)"PRE-FLIPPED");
        Geometry postGeom = handler.postProcess(mt, reprojected);
        Envelope env = postGeom.getEnvelopeInternal();
        double EPS = 1.0E-5;
        Assert.assertEquals((double)0.0, (double)env.getMinX(), (double)EPS);
        Assert.assertEquals((double)-1.0, (double)env.getMaxX(), (double)EPS);
    }
}

