/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.geom.AffineTransform;
import org.geotools.geometry.jts.PointIterator;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.WKTReader;

public class PointIteratorTest {
    @Test
    public void testPointIteration() throws Exception {
        Point p = (Point)new WKTReader().read("POINT(1 10)");
        AffineTransform at = AffineTransform.getScaleInstance(2.0, 2.0);
        PointIterator it = new PointIterator(p, at);
        double[] coords = new double[2];
        Assert.assertFalse((boolean)it.isDone());
        Assert.assertEquals((long)0L, (long)it.currentSegment(coords));
        Assert.assertEquals((double)2.0, (double)coords[0], (double)0.0);
        Assert.assertEquals((double)20.0, (double)coords[1], (double)0.0);
        Assert.assertFalse((boolean)it.isDone());
        it.next();
        Assert.assertEquals((long)1L, (long)it.currentSegment(coords));
        Assert.assertEquals((double)2.0, (double)coords[0], (double)0.0);
        Assert.assertEquals((double)20.0, (double)coords[1], (double)0.0);
        Assert.assertTrue((boolean)it.isDone());
    }
}

