/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.awt.Color;
import java.util.ArrayList;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.function.SEFunctionTestBase;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RecodeFunctionTest
extends SEFunctionTestBase {
    private final Integer[] ints = new Integer[]{1, 2, 3};
    private final String[] words = new String[]{"UPPER", "lower", "MiXeD"};
    private final Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE};

    @Before
    public void setup() {
        this.parameters = new ArrayList();
    }

    @Test
    public void testFindFunction() throws Exception {
        Literal fallback = this.ff2.literal((Object)"NOT_FOUND");
        this.setupParameters(this.ints, this.colors);
        Function fn = this.finder.findFunction("recode", this.parameters, fallback);
        Object result = fn.evaluate((Object)this.feature(this.ints[0]));
        Assert.assertNotEquals((String)"Could not locate 'recode' function", (Object)result, (Object)fallback.getValue());
    }

    @Test
    public void testIntToColorLookup() throws Exception {
        this.setupParameters(this.ints, this.colors);
        Function fn = this.finder.findFunction("recode", this.parameters);
        for (int i = 0; i < this.ints.length; ++i) {
            Assert.assertEquals((Object)this.colors[i], (Object)fn.evaluate((Object)this.feature(this.ints[i]), Color.class));
        }
    }

    @Test
    public void testRecodeUndefinedValueReturnsNull() throws Exception {
        this.setupParameters(this.words, this.ints);
        Function fn = this.finder.findFunction("recode", this.parameters);
        String missing = "missing";
        Assert.assertNull((Object)fn.evaluate((Object)this.feature("missing")));
    }

    private void setupParameters(Object[] data, Object[] values) {
        if (data.length != values.length) {
            throw new IllegalArgumentException("data and values arrays should be the same length");
        }
        this.parameters = new ArrayList();
        this.parameters.add(this.ff2.property("value"));
        for (int i = 0; i < data.length; ++i) {
            this.parameters.add(this.ff2.literal(data[i]));
            this.parameters.add(this.ff2.literal(values[i]));
        }
    }

    @Test
    public void testEqualsHashCode() {
        this.setupParameters(this.words, this.ints);
        Function fn1 = this.finder.findFunction("interpolate", this.parameters);
        Function fn2 = this.finder.findFunction("interpolate", this.parameters);
        this.setupParameters(this.words, new Integer[]{1, 2, 5});
        Function fn3 = this.finder.findFunction("interpolate", this.parameters);
        Assert.assertEquals((Object)fn1, (Object)fn2);
        Assert.assertEquals((Object)fn2, (Object)fn1);
        Assert.assertEquals((long)fn1.hashCode(), (long)fn2.hashCode());
        Assert.assertNotEquals((Object)fn1, (Object)fn3);
        Assert.assertNotEquals((Object)fn2, (Object)fn3);
    }
}

