/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class ParseTimeFunctionTest {
    public static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testOrdinaryISODurationNotations() {
        ParseTimeFunctionTest.assertionForParsedInstance("PT30M", Duration.ofMinutes(30L));
        ParseTimeFunctionTest.assertionForParsedInstance("PT12H", Duration.ofHours(12L));
        ParseTimeFunctionTest.assertionForParsedInstance("P4D", Duration.ofDays(4L));
        ParseTimeFunctionTest.assertionForParseLocalDateTIme("P1M", Period.ofMonths(1), ChronoUnit.HOURS);
        ParseTimeFunctionTest.assertionForParseLocalDateTIme("P1Y", Period.ofYears(1), ChronoUnit.DAYS);
    }

    @Test
    public void testTimestamps() {
        ParseTimeFunctionTest.assertionForTimestamp("2025-07-14T12:30:15.000Z", LocalDateTime.of(2025, 7, 14, 12, 30, 15));
        ParseTimeFunctionTest.assertionForTimestamp("20250714T12:30:15.000Z", LocalDateTime.of(2025, 7, 14, 12, 30, 15));
        ParseTimeFunctionTest.assertionForTimestamp("2025-07-10T10:30", LocalDateTime.of(2025, 7, 10, 10, 30));
        ParseTimeFunctionTest.assertionForTimestamp("20250710T10:30", LocalDateTime.of(2025, 7, 10, 10, 30));
    }

    private static void assertionForTimestamp(String expression, LocalDateTime localDateTime) {
        Function parseTime = FF.function("parseTime", new Expression[]{FF.literal((Object)expression)});
        Date date = (Date)parseTime.evaluate(null);
        Assert.assertEquals((Object)localDateTime, (Object)date.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime());
    }

    private static void assertionForParsedInstance(String expression, TemporalAmount timeInThePast) {
        Function parseTime = FF.function("parseTime", new Expression[]{FF.literal((Object)expression)});
        Date date = (Date)parseTime.evaluate(null);
        Instant generatedDate = Instant.now().minus(timeInThePast).truncatedTo(ChronoUnit.SECONDS);
        Instant evaluatedTime = date.toInstant().truncatedTo(ChronoUnit.SECONDS);
        Assert.assertEquals((Object)generatedDate, (Object)evaluatedTime);
    }

    private static void assertionForParseLocalDateTIme(String expression, TemporalAmount timeInThePast, ChronoUnit chronoUnit) {
        Function parseTime = FF.function("parseTime", new Expression[]{FF.literal((Object)expression)});
        Date date = (Date)parseTime.evaluate(null);
        LocalDateTime generatedDate = LocalDateTime.now().minus(timeInThePast).truncatedTo(chronoUnit);
        LocalDateTime evaluatedTime = date.toInstant().atZone(ZoneOffset.UTC).toLocalDateTime().truncatedTo(chronoUnit);
        Assert.assertEquals((Object)generatedDate, (Object)evaluatedTime);
    }
}

