/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Collections;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;

public class MapGetFunctionTest {
    static FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private SimpleFeatureType sampleDataType;
    private String namespace = "ns";
    private SimpleFeature[] features;
    private GeometryFactory gf;

    @Before
    public void setUp() throws Exception {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("map");
        builder.setNamespaceURI(this.namespace);
        builder.add(this.createAttribute("id", String.class));
        builder.add(this.createAttribute("geom", LineString.class));
        builder.setDefaultGeometry("geom");
        builder.add(this.createAttribute("name", String.class));
        builder.add(this.createAttribute("attributes", Map.class));
        this.sampleDataType = builder.buildFeatureType();
        this.gf = new GeometryFactory();
        this.features = new SimpleFeature[3];
        this.features[0] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{1, this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "object1", Map.ofEntries(Map.entry("name", "firstObject"), Map.entry("valid", false), Map.entry("score", 100), Map.entry("key1", "value1"))}, (String)"sample.s1");
        this.features[1] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{2, this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "object2", Map.ofEntries(Map.entry("name", "secondObject"), Map.entry("valid", true), Map.entry("score", 50), Map.entry("key1", 10))}, (String)"sample.s2");
        this.features[2] = SimpleFeatureBuilder.build((SimpleFeatureType)this.sampleDataType, (Object[])new Object[]{2, this.line(new int[]{3, 2, 4, 2, 5, 3}), "object3", Map.ofEntries(Map.entry("name", "thirdObject"), Map.entry("score", 70), Map.entry("key1", true))}, (String)"sample.s3");
    }

    private AttributeDescriptor createAttribute(String name, Class clazz) {
        AttributeTypeImpl at = new AttributeTypeImpl((Name)new NameImpl(name), clazz, false, false, Collections.emptyList(), null, null);
        return new AttributeDescriptorImpl((AttributeType)at, (Name)new NameImpl(name), 0, 1, false, null);
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    @Test
    public void testEvaluate() {
        Function f = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"name")});
        Assert.assertEquals((Object)"firstObject", (Object)f.evaluate((Object)this.features[0], String.class));
        Assert.assertEquals((Object)"secondObject", (Object)f.evaluate((Object)this.features[1], String.class));
        Assert.assertEquals((Object)"thirdObject", (Object)f.evaluate((Object)this.features[2], String.class));
        PropertyIsGreaterThan gt = FF.greater((Expression)FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"score")}), (Expression)FF.literal(80));
        Assert.assertTrue((boolean)gt.evaluate((Object)this.features[0]));
        Assert.assertFalse((boolean)gt.evaluate((Object)this.features[1]));
        Assert.assertFalse((boolean)gt.evaluate((Object)this.features[2]));
        Function f2 = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"valid")});
        Assert.assertFalse((boolean)((Boolean)f2.evaluate((Object)this.features[0], Boolean.class)));
        Assert.assertTrue((boolean)((Boolean)f2.evaluate((Object)this.features[1], Boolean.class)));
        Assert.assertNull((Object)f2.evaluate((Object)this.features[2], Boolean.class));
        Function f3 = FF.function("mapGet", new Expression[]{FF.property("attributes"), FF.literal((Object)"key1")});
        Assert.assertEquals((Object)"value1", (Object)f3.evaluate((Object)this.features[0], String.class));
        Assert.assertEquals((Object)10, (Object)f3.evaluate((Object)this.features[1], Integer.class));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)f3.evaluate((Object)this.features[2], Boolean.class));
        Function f4 = FF.function("mapGet", new Expression[]{FF.property("missingMap"), FF.literal((Object)"key1")});
        Assert.assertNull((Object)f4.evaluate((Object)this.features[0], String.class));
    }
}

