/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression;

import java.util.List;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;

public class PropertyAccessorsFactoryTest {
    @Test
    public void testPropertyAccessorsFactoryPriority() {
        List propertyAccessors = PropertyAccessors.findPropertyAccessors((Object)new PriorityMockDataObject(), (String)"", null, null);
        Assert.assertEquals((long)2L, (long)propertyAccessors.size());
        Assert.assertTrue((boolean)(propertyAccessors.get(0) instanceof HighPriorityMockPropertyAccessor));
        Assert.assertTrue((boolean)(propertyAccessors.get(1) instanceof LowPriorityMockPropertyAccessor));
    }

    public static class PriorityMockDataObject {
    }

    public static class LowPriorityMockPropertyAccessor
    extends PriorityMockPropertyAccessor {
    }

    public static class HighPriorityMockPropertyAccessor
    extends PriorityMockPropertyAccessor {
    }

    public static class PriorityMockPropertyAccessor
    implements PropertyAccessor {
        public boolean canHandle(Object object, String xpath, Class target) {
            return object instanceof PriorityMockDataObject;
        }

        public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }

        public void set(Object object, String xpath, Object value, Class target) throws IllegalArgumentException {
            throw new UnsupportedOperationException();
        }
    }

    public static class HighPriorityMockPropertyAccessorFactory
    implements PropertyAccessorFactory {
        public int getPriority() {
            return 5000;
        }

        public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
            if (!PriorityMockDataObject.class.equals((Object)type)) {
                return null;
            }
            return new HighPriorityMockPropertyAccessor();
        }
    }

    public static class LowPriorityMockPropertyAccessorFactory
    implements PropertyAccessorFactory {
        public int getPriority() {
            return 0;
        }

        public PropertyAccessor createPropertyAccessor(Class type, String xpath, Class target, Hints hints) {
            if (!PriorityMockDataObject.class.equals((Object)type)) {
                return null;
            }
            return new LowPriorityMockPropertyAccessor();
        }
    }
}

