/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.logging.Logger;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.logging.Logging;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterCapabilitiesTest {
    private static final Logger LOGGER = Logging.getLogger(FilterCapabilitiesTest.class);
    private Filter gFilter;
    private Filter compFilter;
    private Filter logFilter;
    private FilterCapabilities capabilities;
    private FilterFactory fact = CommonFactoryFinder.getFilterFactory();
    boolean setup = false;

    @Before
    public void setUp() {
        LOGGER.finer("Setting up FilterCapabilitiesTest");
        if (this.setup) {
            return;
        }
        this.setup = true;
        this.capabilities = new FilterCapabilities();
        try {
            this.gFilter = this.fact.within((Expression)this.fact.property("geom"), (Expression)this.fact.literal(null));
            this.compFilter = this.fact.less((Expression)this.fact.property("size"), (Expression)this.fact.literal(3));
        }
        catch (IllegalFilterException ife) {
            LOGGER.fine("Bad filter " + ife);
        }
        this.capabilities.addType(Or.class);
        this.capabilities.addType(And.class);
        this.capabilities.addType(Not.class);
        this.capabilities.addType(PropertyIsEqualTo.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsBetween.class);
    }

    @Test
    public void testAdd() {
        this.capabilities.addType(PropertyIsGreaterThan.class);
        this.capabilities.addType(PropertyIsLessThan.class);
        this.capabilities.addType(PropertyIsNull.class);
        Assert.assertTrue((boolean)this.capabilities.supports(PropertyIsNull.class));
    }

    @Test
    public void testShortSupports() {
        Assert.assertTrue((boolean)this.capabilities.supports(And.class));
        Assert.assertFalse((boolean)this.capabilities.supports(PropertyIsLike.class));
    }

    @Test
    public void testFilterSupports() {
        Assert.assertTrue((boolean)this.capabilities.supports(this.compFilter));
        Assert.assertFalse((boolean)this.capabilities.supports(this.gFilter));
    }

    @Test
    public void testFullySupports() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        try {
            this.logFilter = ff.and(this.gFilter, this.compFilter);
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.compFilter));
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.gFilter));
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.and(this.compFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.or(this.logFilter, (Filter)ff.between((Expression)ff.property("sample"), (Expression)ff.literal(1), (Expression)ff.literal(2)));
            Assert.assertTrue((boolean)this.capabilities.fullySupports(this.logFilter));
            this.logFilter = ff.and(this.logFilter, this.gFilter);
            Assert.assertFalse((boolean)this.capabilities.fullySupports(this.logFilter));
        }
        catch (IllegalFilterException e) {
            LOGGER.fine("Bad filter " + e);
        }
    }
}

