/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.ExceptionChecker;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.FeatureFactory;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.AttributeBuilder;
import org.geotools.feature.FakeTypes;
import org.geotools.feature.LenientFeatureFactoryImpl;
import org.geotools.feature.NameImpl;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AttributeBuilderTest {
    private AttributeBuilder builder;

    @Before
    public void setUp() {
        this.builder = new AttributeBuilder((FeatureFactory)new LenientFeatureFactoryImpl());
    }

    @After
    public void tearDown() {
        this.builder = null;
    }

    @Test
    public void setType_validType_descriptorIsSetToNull() {
        this.builder.setType(FakeTypes.ANYSIMPLETYPE_TYPE);
        Assert.assertNull((Object)this.builder.getDescriptor());
    }

    @Test
    public void setDescriptor_validDescriptor_typeIsSetToDescriptorsType() {
        this.builder.setDescriptor(FakeTypes.Mine.mineNAME_DESCRIPTOR);
        Assert.assertSame((Object)FakeTypes.Mine.mineNAME_DESCRIPTOR.getType(), (Object)this.builder.getType());
    }

    @Test
    public void add_validArguments_returnsAttributeImpl() {
        this.builder.setType((AttributeType)FakeTypes.Mine.MINENAMETYPE_TYPE);
        Attribute mineName = this.builder.add("test_id", (Object)"Sharlston Colliery", FakeTypes.Mine.NAME_mineName);
        Assert.assertEquals((Object)"AttributeImpl:mineName<string id=test_id>=Sharlston Colliery", (Object)mineName.toString());
    }

    @Test
    public void add_validArguments_attributeIsAddedToProperties() {
        this.builder.setType((AttributeType)FakeTypes.Mine.MINENAMETYPE_TYPE);
        Attribute mineName = this.builder.add("test_id", (Object)"Sharlston Colliery", FakeTypes.Mine.NAME_mineName);
        Assert.assertTrue((boolean)this.builder.getProperties().contains(mineName));
    }

    @Test(expected=IllegalArgumentException.class)
    public void add_invalidName_throwsIllegalArgumentException() throws Exception {
        this.builder.setType((AttributeType)FakeTypes.Mine.MINENAMETYPE_TYPE);
        try {
            this.builder.add("test_id", (Object)"Sharlston Colliery", (Name)new NameImpl("urn:org:example", "INVALID_NAME"));
        }
        catch (IllegalArgumentException iae) {
            ExceptionChecker.assertExceptionMessage(iae, "Could not locate attribute: urn:org:example:INVALID_NAME in type: urn:org:example:MineNameType");
        }
    }

    @Test
    public void build_typeIsMineNameTypeAndAddedDataIsValid_buildsAComplexAttributeImpl() {
        this.builder.setType((AttributeType)FakeTypes.Mine.MINENAMETYPE_TYPE);
        this.builder.add("test_id 1", (Object)true, FakeTypes.Mine.NAME_isPreferred);
        this.builder.add("test_id", (Object)"Sharlston Colliery", FakeTypes.Mine.NAME_mineName);
        Attribute MineName = this.builder.build();
        Assert.assertEquals((Object)"ComplexAttributeImpl:MineNameType=[AttributeImpl:isPreferred<boolean id=test_id 1>=true, AttributeImpl:mineName<string id=test_id>=Sharlston Colliery]", (Object)MineName.toString());
    }
}

