/*
 *    GeoTools - The Open Source Java GIS Toolkit
 *    http://geotools.org
 *
 *    (C) 2008, Open Source Geospatial Foundation (OSGeo)
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation;
 *    version 2.1 of the License.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.expression.Expression;

/**
 * This function recodes values from a property or expression into corresponding values of arbitrary type. The
 * comparisons are performed checking for identical values.
 *
 * @version <A HREF="http://www.opengeospatial.org/standards/symbol">Symbology Encoding Implementation Specification
 *     1.1.0</A>
 * @author Johann Sorel (Geomatys)
 */
public interface MapItem extends Expression {

    /**
     * Get value.
     *
     * <p>The Values can be of any type, dependent on which symbolization context the function is employed. Color values
     * (like #00ffff) or numeric values are typical.
     *
     * @return Expression
     */
    Expression getValue();

    /**
     * Get data.
     *
     * @return double
     */
    double getData();
}
