/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ContrastEnhancement;
import org.geotools.api.style.SelectedChannelType;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.util.Utilities;

public class SelectedChannelTypeImpl
implements SelectedChannelType {
    private FilterFactory filterFactory;
    private ContrastEnhancement contrastEnhancement;
    private Expression name = Expression.NIL;

    public SelectedChannelTypeImpl() {
        this(CommonFactoryFinder.getFilterFactory(null));
    }

    public SelectedChannelTypeImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.contrastEnhancement = this.contrastEnhancement((Expression)this.filterFactory.literal(1.0));
    }

    public SelectedChannelTypeImpl(FilterFactory factory, ContrastEnhancement contrast) {
        this.filterFactory = factory;
        this.contrastEnhancement = contrast;
    }

    public SelectedChannelTypeImpl(SelectedChannelType gray) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory(null);
        this.name = gray.getChannelName();
        if (gray.getContrastEnhancement() != null) {
            this.contrastEnhancement = new ContrastEnhancementImpl(gray.getContrastEnhancement());
        }
    }

    public Expression getChannelName() {
        return this.name;
    }

    public ContrastEnhancement getContrastEnhancement() {
        return this.contrastEnhancement;
    }

    public void setChannelName(Expression name) {
        this.name = name;
    }

    public void setChannelName(String name) {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.name = ff.literal((Object)name);
    }

    public void setContrastEnhancement(ContrastEnhancement enhancement) {
        this.contrastEnhancement = ContrastEnhancementImpl.cast(enhancement);
    }

    public void setContrastEnhancement(Expression gammaValue) {
        this.contrastEnhancement.setGammaValue(gammaValue);
    }

    protected ContrastEnhancement contrastEnhancement(Expression expr) {
        ContrastEnhancementImpl enhancement = new ContrastEnhancementImpl();
        enhancement.setGammaValue((Expression)this.filterFactory.literal(1.0));
        return enhancement;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((SelectedChannelType)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((SelectedChannelType)this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.name != null) {
            result = 1000003 * result + this.name.hashCode();
        }
        if (this.contrastEnhancement != null) {
            result = 1000003 * result + this.contrastEnhancement.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SelectedChannelTypeImpl) {
            SelectedChannelTypeImpl other = (SelectedChannelTypeImpl)obj;
            return Utilities.equals((Object)this.name, (Object)other.name) && Utilities.equals((Object)this.contrastEnhancement, (Object)other.contrastEnhancement);
        }
        return false;
    }
}

