/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.EquidistantCylindrical;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;

public class PlateCarreeHandlerFactory
implements ProjectionHandlerFactory {
    private static final ReferencedEnvelope VALID_AREA = new ReferencedEnvelope(-2.147483647E9, 2.147483647E9, -90.0, 90.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        ProjectionHandler handler;
        if (renderingEnvelope == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection((CoordinateReferenceSystem)renderingEnvelope.getCoordinateReferenceSystem());
        boolean isEquidistantCylindrical = mapProjection instanceof EquidistantCylindrical;
        if (!isEquidistantCylindrical) {
            return null;
        }
        double centralMeridian = mapProjection.getParameterValues().parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
        if (wrap && maxWraps > 0) {
            handler = new WrappingProjectionHandler(renderingEnvelope, VALID_AREA, sourceCrs, centralMeridian, maxWraps);
        } else {
            handler = new ProjectionHandler(sourceCrs, VALID_AREA, renderingEnvelope);
            handler.setCentralMeridian(centralMeridian);
        }
        if (!wrap) {
            handler.queryAcrossDateline = false;
        }
        return handler;
    }
}

