/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.net.URL;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.StyleVisitor;
import org.geotools.styling.AbstractStyleVisitor;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.StyleFactoryImpl;
import org.junit.Assert;
import org.junit.Test;

public class ExternalGraphicImplTest {
    private static final String TEST_URL = "http://test.io/graphic.png";
    private static final String TEST_FORMAT = "image/png";

    @Test
    public void testOnlineResourceConsistency() throws Exception {
        CheckOnlineResource testObject = new CheckOnlineResource();
        ExternalGraphicImpl external = new ExternalGraphicImpl();
        external.setLocation(new URL(TEST_URL));
        external.accept((StyleVisitor)testObject);
        external.setURI(TEST_URL);
        external.accept((StyleVisitor)testObject);
        StyleFactoryImpl fact = new StyleFactoryImpl();
        external = fact.createExternalGraphic(TEST_URL, TEST_FORMAT);
        external.accept((StyleVisitor)testObject);
    }

    private static class CheckOnlineResource
    extends AbstractStyleVisitor {
        private CheckOnlineResource() {
        }

        public void visit(ExternalGraphic exgr) {
            Assert.assertNotNull((Object)exgr.getOnlineResource());
            Assert.assertEquals((Object)ExternalGraphicImplTest.TEST_URL, (Object)exgr.getOnlineResource().getLinkage().toString());
        }
    }
}

