/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts.coordinatesequence;

import org.geotools.geometry.jts.GeometryBuilder;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class CoordinateSequencesTest {
    static GeometryFactory gf = new GeometryFactory();
    static LiteCoordinateSequenceFactory liteCSF = new LiteCoordinateSequenceFactory();
    static GeometryFactory liteGF = new GeometryFactory((CoordinateSequenceFactory)liteCSF);
    static GeometryBuilder geomBuilder = new GeometryBuilder();

    @Test
    public void testCoordinateDimensionPointLite1D() {
        Point geom = geomBuilder.point(1.0);
        Assert.assertEquals((long)1L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPointLite2D() {
        Point geom = liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0}, 2));
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPointLite3D() {
        Point geom = liteGF.createPoint((CoordinateSequence)new LiteCoordinateSequence(new double[]{1.0, 2.0, 99.0}, 3));
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionLineString1D() {
        LineString geom = gf.createLineString(new Coordinate[]{new Coordinate(1.0, Double.NaN), new Coordinate(3.0, Double.NaN)});
        Assert.assertEquals((long)1L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionLineString2D() {
        LineString geom = gf.createLineString(new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0)});
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionLineStringLite3D() {
        LineString geom = liteGF.createLineString(liteCSF.create(new double[]{1.0, 2.0, 100.0, 3.0, 4.0, 200.0}, 3));
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonLite2D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0}, 2)), null);
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonLite3D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 100.0, 2.0, 1.0, 99.0, 2.0, 2.0, 98.0, 1.0, 2.0, 97.0, 1.0, 1.0, 100.0}, 3)), null);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonEmpty() {
        Polygon geom = gf.createPolygon(gf.createLinearRing((Coordinate[])null), null);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonEmptyLite2D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[0], 2)), null);
        Assert.assertEquals((long)2L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionPolygonEmptyLite3D() {
        Polygon geom = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[0], 3)), null);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionGeometryCollectionEmptyLite3D() {
        GeometryCollection geom = liteGF.createGeometryCollection(new Geometry[0]);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testCoordinateDimensionGeometryCollectionEmpty() {
        GeometryCollection geom = gf.createGeometryCollection(new Geometry[0]);
        Assert.assertEquals((long)3L, (long)CoordinateSequences.coordinateDimension((Geometry)geom));
    }

    @Test
    public void testEqualityND() {
        Polygon g1 = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 100.0, 2.0, 1.0, 99.0, 2.0, 2.0, 98.0, 1.0, 2.0, 97.0, 1.0, 1.0, 100.0}, 3)), null);
        Polygon g2 = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 2.0, 1.0, 2.0, 2.0, 1.0, 2.0, 1.0, 1.0}, 2)), null);
        Polygon g3 = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 200.0, 2.0, 1.0, 199.0, 2.0, 2.0, 198.0, 1.0, 2.0, 197.0, 1.0, 1.0, 200.0}, 3)), null);
        Polygon g4 = liteGF.createPolygon(liteGF.createLinearRing(liteCSF.create(new double[]{1.0, 1.0, 100.0, 2.0, 1.0, 99.0, 2.0, 2.0, 98.0, 1.0, 2.0, 97.0, 1.0, 1.0, 100.0}, 3)), null);
        Assert.assertTrue((boolean)CoordinateSequences.equalsND((Geometry)g1, (Geometry)g4));
        Assert.assertFalse((boolean)CoordinateSequences.equalsND((Geometry)g1, (Geometry)g2));
        Assert.assertFalse((boolean)CoordinateSequences.equalsND((Geometry)g1, (Geometry)g3));
    }
}

