/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.DataUtilities;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.ExpressionTypeVisitor;
import org.geotools.filter.visitor.RangeCombiner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RangeCombinerTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    ExpressionTypeVisitor visitor;
    SimpleFeatureType ft;

    @Before
    public void setup() throws Exception {
        this.ft = DataUtilities.createType((String)"test", (String)"theGeom:LineString,b:java.lang.Byte,s:java.lang.Short,i:java.lang.Integer,l:java.lang.Long,d:java.lang.Double,label:String");
        this.visitor = new ExpressionTypeVisitor((FeatureType)this.ft);
    }

    @Test
    public void testOtherFilter() {
        PropertyName label = this.ff.property("label");
        PropertyIsGreaterThan f1 = this.ff.greater((Expression)label, (Expression)this.ff.literal((Object)"abc"));
        PropertyIsGreaterThan f2 = this.ff.greater((Expression)label, (Expression)this.ff.literal((Object)"adc"));
        PropertyIsNotEqualTo f3 = this.ff.notEqual((Expression)this.ff.function("random", new Expression[0]), (Expression)this.ff.property("i"));
        RangeCombiner.And rc = new RangeCombiner.And(this.ff, (FeatureType)this.ft, Arrays.asList(f1, f2, f3));
        List reduced = rc.getReducedFilters();
        Assert.assertEquals((long)2L, (long)reduced.size());
        Assert.assertTrue((boolean)reduced.contains(f2));
        Assert.assertTrue((boolean)reduced.contains(f3));
    }
}

