/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.function.math.IntegerDivisionFunction;
import org.junit.Assert;
import org.junit.Test;

public class IntegerDivisionTest {
    private final String FUNCTION_NAME = IntegerDivisionFunction.NAME.getName();
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testDivInvalidInitNoArgs() {
        try {
            this.ff.function(this.FUNCTION_NAME, new Expression[0]);
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.FUNCTION_NAME), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testDivInvalidInitOneArg() {
        try {
            this.ff.function(this.FUNCTION_NAME, new Expression[]{this.ff.literal(13)});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.FUNCTION_NAME), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testDivInvalidInitThreeArgs() {
        try {
            this.ff.function(this.FUNCTION_NAME, new Expression[]{this.ff.literal(13), this.ff.literal(14), this.ff.literal(15)});
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)("Unable to find function " + this.FUNCTION_NAME), (Object)e.getMessage());
            return;
        }
        Assert.fail((String)"Exception not thrown");
    }

    @Test
    public void testIntegerDivision() {
        Function function = this.ff.function(this.FUNCTION_NAME, new Expression[]{this.ff.literal(13), this.ff.literal(4)});
        Assert.assertEquals((Object)3, (Object)function.evaluate(null));
    }

    @Test
    public void testIntegerDivisionConversion() {
        Function function = this.ff.function(this.FUNCTION_NAME, new Expression[]{this.ff.literal(13.2), this.ff.literal(4.2)});
        Assert.assertEquals((Object)3, (Object)function.evaluate(null));
    }
}

