/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.Test;

public class LikeFilterImplTest {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory();

    @Test
    public void testEmptyWildCard() {
        try {
            PropertyIsLike l = this.ff.like((Expression)this.ff.literal((Object)"foo"), "foo", "", "?", "-");
            l.evaluate(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmptySingleWildCard() {
        try {
            PropertyIsLike l = this.ff.like((Expression)this.ff.literal((Object)"foo"), "foo", "*", "", "-");
            l.evaluate(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReDOS1() {
        try {
            PropertyIsLike l = this.ff.like((Expression)this.ff.function("strTrim", new Expression[]{this.ff.literal((Object)"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab")}), "$", "*", "?", "(a+)+");
            l.evaluate(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReDOS2() {
        try {
            PropertyIsLike l = this.ff.like((Expression)this.ff.literal((Object)"hchcchicihcchciiicichhcichcihcchiihichiciiiihhcchicchhcihchcihiihciichhccciccichcichiihcchcihhicchcciicchcccihiiihhihihihichicihhcciccchihhhcchichchciihiicihciihcccciciccicciiiiiiiiicihhhiiiihchccchchhhhiiihchihcccchhhiiiiiiiicicichicihcciciihichhhhchihciiihhiccccccciciihhichiccchhicchicihihccichicciihcichccihhiciccccccccichhhhihihhcchchihihiihhihihihicichihiiiihhhhihhhchhichiicihhiiiiihchccccchichci"), "$", "*", "?", "(h|h|ih(((i|a|c|c|a|i|i|j|b|a|i|b|a|a|j))+h)ahbfhba|c|i)*");
            l.evaluate(null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testAmpersandHandling() {
        String input = "this is foo & bar geospatial";
        String pattern = "*foo & bar*";
        PropertyIsLike pil = this.ff.like((Expression)this.ff.literal((Object)input), pattern);
        String msg = String.format("Expecting '%s' to match '%s'.", pattern, input);
        Assert.assertTrue((String)msg, (boolean)pil.evaluate(null));
        pil = this.ff.like((Expression)this.ff.literal((Object)input), pattern, "*", "?", "!");
        Assert.assertTrue((String)msg, (boolean)pil.evaluate(null));
    }
}

