/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.EnvFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;

public class FilterAttributeExtractorTest {
    boolean set = false;
    FilterAttributeExtractor fae;
    FilterFactory fac;

    @Before
    public void setUp() throws SchemaException {
        if (this.set) {
            return;
        }
        this.set = true;
        this.fae = new FilterAttributeExtractor();
        this.fac = CommonFactoryFinder.getFilterFactory(null);
    }

    @Test
    public void testPropertyNameSet() throws IllegalFilterException {
        PropertyIsEqualTo filter = this.fac.equals((Expression)this.fac.property("testString"), (Expression)this.fac.literal((Object)"test string data"));
        PropertyName expression1 = this.fac.property("code");
        Function expression2 = this.fac.function("length", new Expression[]{this.fac.property("identification")});
        FilterAttributeExtractor extract = new FilterAttributeExtractor(null);
        HashSet names = new HashSet();
        expression1.accept((ExpressionVisitor)extract, names);
        expression2.accept((ExpressionVisitor)extract, names);
        filter.accept((FilterVisitor)extract, names);
        String[] array = extract.getAttributeNames();
        Set attributes = extract.getAttributeNameSet();
        Set properties = extract.getPropertyNameSet();
        Assert.assertEquals((long)3L, (long)array.length);
        Assert.assertEquals((long)3L, (long)attributes.size());
        Assert.assertEquals((long)3L, (long)properties.size());
    }

    @Test
    public void testCompare() throws IllegalFilterException {
        PropertyIsEqualTo filter = this.fac.equals((Expression)this.fac.property("testString"), (Expression)this.fac.literal((Object)"test string data"));
        this.assertAttributeName((Filter)filter, "testString");
    }

    private void assertAttributeName(Filter filter, String ... names) {
        this.fae.clear();
        filter.accept((FilterVisitor)this.fae, null);
        Set attNames = this.fae.getAttributeNameSet();
        Assert.assertNotNull((Object)attNames);
        Assert.assertEquals((long)attNames.size(), (long)names.length);
        for (String name : names) {
            Assert.assertTrue((boolean)attNames.contains(name));
        }
        Set propNames = this.fae.getPropertyNameSet();
        Assert.assertNotNull((Object)propNames);
        Assert.assertEquals((long)attNames.size(), (long)propNames.size());
        for (PropertyName pn : propNames) {
            Assert.assertTrue((boolean)attNames.contains(pn.getPropertyName()));
        }
    }

    @Test
    public void testLike() throws IllegalFilterException {
        PropertyIsLike filter = this.fac.like((Expression)this.fac.property("testString"), "abc");
        this.assertAttributeName((Filter)filter, "testString");
    }

    @Test
    public void testNull() throws IllegalFilterException {
        PropertyIsNull filter = this.fac.isNull((Expression)this.fac.property("foo"));
        this.assertAttributeName((Filter)filter, "foo");
    }

    @Test
    public void testBetween() throws IllegalFilterException {
        Literal lower = this.fac.literal(1001);
        Literal upper = this.fac.literal(1003);
        PropertyName pint = this.fac.property("testInteger");
        PropertyName plong = this.fac.property("testLong");
        PropertyName pfloat = this.fac.property("testFloat");
        this.assertAttributeName((Filter)this.fac.between((Expression)lower, (Expression)lower, (Expression)upper), new String[0]);
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)lower, (Expression)upper), "testInteger");
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)pint, (Expression)pint), "testInteger");
        this.assertAttributeName((Filter)this.fac.between((Expression)pint, (Expression)plong, (Expression)pfloat), "testInteger", "testLong", "testFloat");
    }

    @Test
    public void testGeometry() throws IllegalFilterException {
        Coordinate[] coords = new Coordinate[]{new Coordinate(1.0, 2.0), new Coordinate(3.0, 4.0), new Coordinate(5.0, 6.0)};
        PropertyName att = this.fac.property("testGeometry");
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Literal geom = this.fac.literal((Object)gf.createLineString(coords));
        Equals filter = this.fac.equal((Expression)att, (Expression)geom);
        this.assertAttributeName((Filter)filter, "testGeometry");
        filter = this.fac.equal((Expression)att, (Expression)att);
        this.assertAttributeName((Filter)filter, "testGeometry");
        filter = this.fac.equal((Expression)geom, (Expression)att);
        this.assertAttributeName((Filter)filter, "testGeometry");
    }

    @Test
    public void testDistanceGeometry() throws Exception {
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(10.0, 10.0), new Coordinate(15.0, 10.0), new Coordinate(15.0, 15.0), new Coordinate(10.0, 15.0), new Coordinate(10.0, 10.0)};
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Literal right = this.fac.literal((Object)gf.createPolygon(gf.createLinearRing(coords2), null));
        DWithin filter = this.fac.dwithin((Expression)this.fac.property("testGeometry"), (Expression)right, 10.0, "m");
        this.assertAttributeName((Filter)filter, "testGeometry");
    }

    @Test
    public void testFid() {
        Id filter = this.fac.id(Collections.singleton(this.fac.featureId("fakeId")));
        this.assertAttributeName((Filter)filter, new String[0]);
    }

    @Test
    public void testLogic() throws IllegalFilterException {
        PropertyName testAttribute = this.fac.property("testString");
        PropertyIsEqualTo filterTrue = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal((Object)"test string data"));
        PropertyIsEqualTo filterFalse = this.fac.equals((Expression)testAttribute, (Expression)this.fac.literal((Object)"incorrect test string data"));
        Or filter = this.fac.or(Arrays.asList(filterFalse, filterTrue));
        this.assertAttributeName((Filter)filter, "testString");
    }

    @Test
    public void testDynamicProperty() throws Exception {
        Function func = this.fac.function("property", new Expression[]{this.fac.function("env", new Expression[]{this.fac.literal((Object)"pname")})});
        PropertyIsEqualTo filter = this.fac.equals((Expression)func, (Expression)this.fac.literal((Object)"test"));
        try {
            EnvFunction.setLocalValue((String)"pname", (Object)"name");
            this.assertAttributeName((Filter)filter, "name");
        }
        finally {
            EnvFunction.clearLocalValues();
        }
    }
}

