/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataTestCase;
import org.geotools.data.util.NullProgressListener;
import org.geotools.feature.visitor.Aggregate;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.GroupByVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Test;

public class VisitorResultTypeTest
extends DataTestCase {
    @Test
    public void testAverageInteger() {
        AverageVisitor visitor = new AverageVisitor((Expression)this.ff.property("id"));
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class));
    }

    @Test
    public void testAverageDouble() {
        AverageVisitor visitor = new AverageVisitor((Expression)this.ff.property("flow"));
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Double.class));
    }

    @Test
    public void testMaxInteger() {
        MaxVisitor visitor = new MaxVisitor((Expression)this.ff.property("id"));
        Assert.assertEquals(Arrays.asList(Integer.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class));
    }

    @Test
    public void testMaxDouble() {
        MaxVisitor visitor = new MaxVisitor((Expression)this.ff.property("flow"));
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Double.class));
    }

    @Test
    public void testGroupByAverageInteger() {
        GroupByVisitor visitor = new GroupByVisitor(Aggregate.AVERAGE, (Expression)this.ff.property("id"), Arrays.asList(this.ff.property("id")), (ProgressListener)new NullProgressListener());
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class, Integer.class));
    }

    @Test
    public void testGroupByAverageDouble() {
        GroupByVisitor visitor = new GroupByVisitor(Aggregate.AVERAGE, (Expression)this.ff.property("id"), Arrays.asList(this.ff.property("flow")), (ProgressListener)new NullProgressListener());
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class, Double.class));
    }

    @Test
    public void testGroupByMaxInteger() {
        GroupByVisitor visitor = new GroupByVisitor(Aggregate.MAX, (Expression)this.ff.property("id"), Arrays.asList(this.ff.property("id")), (ProgressListener)new NullProgressListener());
        Assert.assertEquals(Arrays.asList(Integer.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class, Integer.class));
    }

    @Test
    public void testGroupByMaxDouble() {
        GroupByVisitor visitor = new GroupByVisitor(Aggregate.MAX, (Expression)this.ff.property("id"), Arrays.asList(this.ff.property("flow")), (ProgressListener)new NullProgressListener());
        Assert.assertEquals(Arrays.asList(Double.class), this.getResultTypes((FeatureAttributeVisitor)visitor, Integer.class, Double.class));
    }

    private List<Class> getResultTypes(FeatureAttributeVisitor visitor, Class ... inputTypes) {
        return (List)visitor.getResultType(Arrays.asList(inputTypes)).get();
    }
}

