/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SampleFeatureFixtures;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class FeatureFlatTest {
    private SimpleFeature testFeature = null;

    @Before
    public void setUp() {
        this.testFeature = SampleFeatureFixtures.createFeature();
    }

    @Test
    public void testRetrieve() {
        GeometryFactory gf = new GeometryFactory();
        Assert.assertTrue((String)"geometry retrieval and match", (boolean)((Point)this.testFeature.getAttribute("testGeometry")).equalsExact((Geometry)gf.createPoint(new Coordinate(1.0, 2.0))));
        Assert.assertEquals((String)"boolean retrieval and match", (Object)this.testFeature.getAttribute("testBoolean"), (Object)Boolean.TRUE);
        Assert.assertEquals((String)"character retrieval and match", (Object)this.testFeature.getAttribute("testCharacter"), (Object)Character.valueOf('t'));
        Assert.assertEquals((String)"byte retrieval and match", (Object)this.testFeature.getAttribute("testByte"), (Object)Byte.valueOf("10"));
        Assert.assertEquals((String)"short retrieval and match", (Object)this.testFeature.getAttribute("testShort"), (Object)Short.valueOf("101"));
        Assert.assertEquals((String)"integer retrieval and match", (Object)this.testFeature.getAttribute("testInteger"), (Object)1002);
        Assert.assertEquals((String)"long retrieval and match", (Object)this.testFeature.getAttribute("testLong"), (Object)10003L);
        Assert.assertEquals((String)"float retrieval and match", (Object)this.testFeature.getAttribute("testFloat"), (Object)Float.valueOf(10000.4f));
        Assert.assertEquals((String)"double retrieval and match", (Object)this.testFeature.getAttribute("testDouble"), (Object)100000.5);
        Assert.assertEquals((String)"string retrieval and match", (Object)"test string data", (Object)this.testFeature.getAttribute("testString"));
    }

    @Test
    public void testBogusCreation() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("test1");
        tb.nillable(false).add("billy", String.class);
        tb.nillable(false).add("jimmy", String.class);
        SimpleFeatureType test = tb.buildFeatureType();
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)test, (Object[])new Object[32], null);
            Assert.fail((String)"no error");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testBounds() throws Exception {
        GeometryFactory gf = new GeometryFactory();
        Object[] g = new Geometry[]{gf.createPoint(new Coordinate(0.0, 0.0)), gf.createPoint(new Coordinate(0.0, 10.0)), gf.createPoint(new Coordinate(10.0, 0.0)), gf.createPoint(new Coordinate(10.0, 10.0))};
        GeometryCollection gc = gf.createGeometryCollection((Geometry[])g);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("bounds");
        tb.setCRS(null);
        tb.add("p1", Point.class);
        tb.add("p2", Point.class);
        tb.add("p3", Point.class);
        tb.add("p4", Point.class);
        SimpleFeatureType t = tb.buildFeatureType();
        SimpleFeature f = SimpleFeatureBuilder.build((SimpleFeatureType)t, (Object[])g, null);
        Assert.assertEquals((Object)gc.getEnvelopeInternal(), (Object)f.getBounds());
        g[1].getCoordinate().y = 20.0;
        g[2].getCoordinate().x = 20.0;
        f.setAttribute(1, g[1]);
        f.setAttribute(2, g[2]);
        gc = gf.createGeometryCollection((Geometry[])g);
        Assert.assertEquals((Object)gc.getEnvelopeInternal(), (Object)f.getBounds());
    }

    @Test
    public void testClone() {
        SimpleFeature f = SampleFeatureFixtures.createFeature();
        SimpleFeature c = SimpleFeatureBuilder.copy((SimpleFeature)f);
        int ii = c.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            Assert.assertEquals((Object)c.getAttribute(i), (Object)f.getAttribute(i));
        }
    }

    @Test
    public void testClone2() throws Exception {
        SimpleFeatureType type = SampleFeatureFixtures.createTestType();
        Object[] attributes = SampleFeatureFixtures.createAttributes();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])attributes, (String)"fid");
        SimpleFeature clone = SimpleFeatureBuilder.deep((SimpleFeature)feature);
        Assert.assertEquals((String)"Clone was not equal", (Object)feature, (Object)clone);
    }

    @Test
    public void testToStringWontThrow() throws IllegalAttributeException {
        SimpleFeature f = SampleFeatureFixtures.createFeature();
        f.setAttributes(new Object[f.getAttributeCount()]);
        f.toString();
    }

    static AttributeDescriptor newAtt(String name, Class c) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.setBinding(c);
        return ab.buildDescriptor(name);
    }

    static AttributeDescriptor newAtt(String name, Class c, boolean nillable) {
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        ab.setNillable(nillable);
        ab.setBinding(c);
        return ab.buildDescriptor(name);
    }

    @Test
    public void testModify() throws IllegalAttributeException {
        String newData = "new test string data";
        this.testFeature.setAttribute("testString", (Object)newData);
        Assert.assertEquals((String)"match modified (string) attribute", (Object)this.testFeature.getAttribute("testString"), (Object)newData);
        GeometryFactory gf = new GeometryFactory();
        Point newGeom = gf.createPoint(new Coordinate(3.0, 4.0));
        this.testFeature.setAttribute("testGeometry", (Object)newGeom);
        Assert.assertEquals((String)"match modified (geometry) attribute", (Object)this.testFeature.getAttribute("testGeometry"), (Object)newGeom);
        this.testFeature.setDefaultGeometry((Object)newGeom);
        Assert.assertEquals((String)"match modified (geometry) attribute", (Object)this.testFeature.getAttribute("testGeometry"), (Object)newGeom);
    }

    @Test
    public void testEquals() throws Exception {
        SimpleFeature f1 = SampleFeatureFixtures.createFeature();
        SimpleFeature f2 = SampleFeatureFixtures.createFeature();
        Assert.assertEquals((Object)f1, (Object)f1);
        Assert.assertEquals((Object)f2, (Object)f2);
        Assert.assertNotEquals((Object)f1, (Object)f2);
        Assert.assertNotEquals(null, (Object)f1);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("different");
        tb.add("name", String.class);
        SimpleFeatureType type = tb.buildFeatureType();
        Assert.assertNotEquals((Object)f1, (Object)SimpleFeatureBuilder.build((SimpleFeatureType)type, (Object[])new Object[1], null));
    }
}

