/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.util.SubProgressListener;
import org.junit.Assert;
import org.junit.Test;

public class SubProgressListenerTest {
    @Test
    public void testSubProgressStartComplete() {
        SimpleProgressListener parent = new SimpleProgressListener();
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 50.0f);
        sub.started();
        Assert.assertEquals((float)0.0f, (float)sub.getProgress(), (float)0.0f);
        sub.complete();
        Assert.assertEquals((float)100.0f, (float)sub.getProgress(), (float)0.0f);
    }

    @Test
    public void testSubProgressStartFirstListener() {
        SimpleProgressListener parent = new SimpleProgressListener();
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 0.0f, 50.0f);
        sub.started();
        Assert.assertTrue((boolean)parent.getStarted());
    }

    @Test
    public void testSubProgressStartSubsequentListener() {
        SimpleProgressListener parent = new SimpleProgressListener();
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 50.0f, 50.0f);
        sub.started();
        Assert.assertFalse((boolean)parent.getStarted());
    }

    @Test
    public void testSubProgressBounds() {
        SimpleProgressListener parent = new SimpleProgressListener();
        parent.progress(50.0f);
        SubProgressListener sub = new SubProgressListener((ProgressListener)parent, 50.0f);
        sub.started();
        sub.progress(50.0f);
        Assert.assertEquals((float)50.0f, (float)sub.getProgress(), (float)0.0f);
        Assert.assertEquals((float)75.0f, (float)parent.getProgress(), (float)0.0f);
        sub.progress(100.0f);
        Assert.assertEquals((float)100.0f, (float)sub.getProgress(), (float)0.0f);
        Assert.assertEquals((float)100.0f, (float)parent.getProgress(), (float)0.0f);
    }

    private static class SimpleProgressListener
    implements ProgressListener {
        private float progress;
        private boolean startedCalled = false;

        public void progress(float percent) {
            this.progress = percent;
        }

        public float getProgress() {
            return this.progress;
        }

        public void complete() {
        }

        public boolean getStarted() {
            return this.startedCalled;
        }

        public void started() {
            this.startedCalled = true;
        }

        public void dispose() {
        }

        public void exceptionOccurred(Throwable exception) {
        }

        public String getDescription() {
            return null;
        }

        public InternationalString getTask() {
            return null;
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean cancel) {
        }

        public void setDescription(String description) {
        }

        public void setTask(InternationalString task) {
        }

        public void warningOccurred(String source, String location, String warning) {
        }
    }
}

