/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Mark;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.FontImpl;
import org.geotools.styling.StyleFactoryImpl;
import org.junit.Assert;
import org.junit.Test;

public class StyleTest {
    static FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    static StyleFactoryImpl sf = new StyleFactoryImpl(ff);

    @Test
    public void displacement() {
        Assert.assertNull((Object)DisplacementImpl.cast(null));
        DisplacementImpl displacement = new DisplacementImpl();
        displacement.setDisplacementX(1.0);
        displacement.setDisplacementY(1.0);
        Assert.assertSame((Object)displacement, (Object)DisplacementImpl.cast((Displacement)displacement));
        Assert.assertEquals((Object)displacement, (Object)sf.displacement((Expression)ff.literal(1.0), (Expression)ff.literal(1.0)));
        Displacement external = new Displacement(){

            public Expression getDisplacementY() {
                return ff.literal(1.0);
            }

            public Expression getDisplacementX() {
                return ff.literal(1.0);
            }

            public Object accept(TraversingStyleVisitor visitor, Object data) {
                return visitor.visit((Displacement)this, data);
            }

            public void setDisplacementX(Expression x) {
            }

            public void setDisplacementY(Expression y) {
            }

            public void accept(StyleVisitor visitor) {
            }
        };
        displacement = DisplacementImpl.cast((Displacement)external);
        Assert.assertEquals((Object)ff.literal(1.0), (Object)displacement.getDisplacementX());
    }

    @Test
    public void font() throws Exception {
        ArrayList<Literal> family = new ArrayList<Literal>();
        family.add(ff.literal((Object)"ariel"));
        family.add(ff.literal((Object)"Helvetica"));
        family.add(ff.literal((Object)"sanserif"));
        Literal style = ff.literal((Object)"noraml");
        Literal weight = ff.literal((Object)"normal");
        Literal size = ff.literal(12);
        Font font = sf.font(family, (Expression)style, (Expression)weight, (Expression)size);
        Assert.assertEquals(family, (Object)font.getFamily());
        Assert.assertEquals((Object)style, (Object)font.getStyle());
        Assert.assertEquals((Object)weight, (Object)font.getWeight());
        Assert.assertEquals((Object)size, (Object)font.getSize());
        FontImpl cast = FontImpl.cast((Font)font);
        Assert.assertSame((Object)cast, (Object)font);
    }

    @Test
    public void graphic() throws Exception {
        ArrayList<Mark> symbols = new ArrayList<Mark>();
        symbols.add(sf.mark((Expression)ff.literal((Object)"square"), null, null));
        symbols.add(sf.mark((Expression)ff.literal((Object)"circle"), null, null));
        Expression opacity = null;
        Expression size = null;
        Expression rotation = null;
        AnchorPoint anchor = null;
        Displacement disp = null;
        Graphic graphic = sf.graphic(symbols, opacity, size, rotation, anchor, disp);
        Assert.assertNotNull((Object)graphic);
    }
}

