/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Arrays;
import java.util.Collections;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PointPlacement;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.visitor.DuplicatingStyleVisitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StyleObjectTest {
    private StyleFactory styleFactory;
    private FilterFactory filterFactory;

    @Before
    public void setUp() throws Exception {
        this.styleFactory = CommonFactoryFinder.getStyleFactory();
        this.filterFactory = CommonFactoryFinder.getFilterFactory(null);
    }

    @After
    public void tearDown() throws Exception {
        this.styleFactory = null;
    }

    @Test
    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type-1"));
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.styleFactory.getDefaultStyle();
        style.featureTypeStyles().add(fts);
        style.featureTypeStyles().add(fts2);
        Style clone = (Style)((Cloneable)style).clone();
        StyleObjectTest.assertClone(style, clone);
        Style notEq = this.styleFactory.getDefaultStyle();
        fts2 = this.fts2();
        notEq.featureTypeStyles().add(fts2);
        StyleObjectTest.assertEqualsContract(clone, notEq, style);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.styleFactory.createFeatureTypeStyle();
        Rule rule = this.styleFactory.createRule();
        fts2.rules().add(rule);
        fts2.featureTypeNames().add(new NameImpl("feature-type-2"));
        return fts2;
    }

    @Test
    public void testFeatureTypeStyle() throws Exception {
        FeatureTypeStyle fts = this.styleFactory.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type"));
        Rule rule1 = this.styleFactory.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.filterFactory.id(Collections.singleton(this.filterFactory.featureId("FID"))));
        Rule rule2 = this.styleFactory.createRule();
        rule2.setElseFilter(true);
        rule2.setName("rule2");
        fts.rules().add(rule1);
        fts.rules().add(rule2);
        FeatureTypeStyle clone = (FeatureTypeStyle)((Cloneable)fts).clone();
        StyleObjectTest.assertClone(fts, clone);
        rule1 = this.styleFactory.createRule();
        rule1.setName("rule1");
        rule1.setFilter((Filter)this.filterFactory.id(Collections.singleton(this.filterFactory.featureId("FID"))));
        FeatureTypeStyle notEq = this.styleFactory.createFeatureTypeStyle();
        notEq.setName("fts-not-equal");
        notEq.rules().add(rule1);
        StyleObjectTest.assertEqualsContract(clone, notEq, fts);
    }

    @Test
    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.styleFactory.createLineSymbolizer(this.styleFactory.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.styleFactory.createPolygonSymbolizer(this.styleFactory.getDefaultStroke(), this.styleFactory.getDefaultFill(), "shape");
        Rule rule = this.styleFactory.createRule();
        rule.symbolizers().addAll(Arrays.asList(symb1, symb2));
        Rule clone = (Rule)((Cloneable)rule).clone();
        StyleObjectTest.assertClone(rule, clone);
        symb2 = this.styleFactory.createPolygonSymbolizer(this.styleFactory.getDefaultStroke(), this.styleFactory.getDefaultFill(), "shape");
        Rule notEq = this.styleFactory.createRule();
        notEq.symbolizers().add(symb2);
        StyleObjectTest.assertEqualsContract(clone, notEq, rule);
        symb1 = this.styleFactory.createLineSymbolizer(this.styleFactory.getDefaultStroke(), "geometry");
        clone.symbolizers().clear();
        clone.symbolizers().add(symb1);
        Assert.assertNotEquals((Object)rule, (Object)clone);
    }

    @Test
    public void testPointSymbolizer() throws Exception {
        PointSymbolizer pointSymb = this.styleFactory.createPointSymbolizer();
        PointSymbolizer clone = (PointSymbolizer)((Cloneable)pointSymb).clone();
        StyleObjectTest.assertClone(pointSymb, clone);
        PointSymbolizer notEq = this.styleFactory.getDefaultPointSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, pointSymb);
    }

    @Test
    public void testTextSymbolizer() {
        TextSymbolizer textSymb = this.styleFactory.createTextSymbolizer();
        Literal offset = this.filterFactory.literal(10);
        textSymb.setLabelPlacement((LabelPlacement)this.styleFactory.createLinePlacement((Expression)offset));
        TextSymbolizer clone = (TextSymbolizer)((Cloneable)textSymb).clone();
        StyleObjectTest.assertClone(textSymb, clone);
        TextSymbolizer notEq = this.styleFactory.getDefaultTextSymbolizer();
        Literal ancX = this.filterFactory.literal(10);
        Literal ancY = this.filterFactory.literal(10);
        AnchorPoint ancPoint = this.styleFactory.createAnchorPoint((Expression)ancX, (Expression)ancY);
        PointPlacement placement = this.styleFactory.createPointPlacement(ancPoint, null, null);
        notEq.setLabelPlacement((LabelPlacement)placement);
        StyleObjectTest.assertEqualsContract(clone, notEq, textSymb);
    }

    @Test
    public void testFont() {
        Font font = this.styleFactory.getDefaultFont();
        Font clone = (Font)((Cloneable)font).clone();
        StyleObjectTest.assertClone(font, clone);
        Font other = this.styleFactory.createFont((Expression)this.filterFactory.literal((Object)"other"), (Expression)this.filterFactory.literal((Object)"normal"), (Expression)this.filterFactory.literal((Object)"BOLD"), (Expression)this.filterFactory.literal(12));
        StyleObjectTest.assertEqualsContract(clone, other, font);
    }

    @Test
    public void testHalo() {
        Halo halo = this.styleFactory.createHalo(this.styleFactory.getDefaultFill(), (Expression)this.filterFactory.literal(10));
        Halo clone = (Halo)((Cloneable)halo).clone();
        StyleObjectTest.assertClone(halo, clone);
        Halo other = this.styleFactory.createHalo(this.styleFactory.getDefaultFill(), (Expression)this.filterFactory.literal(12));
        StyleObjectTest.assertEqualsContract(clone, other, halo);
    }

    @Test
    public void testLinePlacement() throws Exception {
        LinePlacement linePlacement = this.styleFactory.createLinePlacement((Expression)this.filterFactory.literal(12));
        LinePlacement clone = (LinePlacement)((Cloneable)linePlacement).clone();
        StyleObjectTest.assertClone(linePlacement, clone);
        LinePlacement other = this.styleFactory.createLinePlacement((Expression)this.filterFactory.property("NAME"));
        StyleObjectTest.assertEqualsContract(clone, other, linePlacement);
    }

    @Test
    public void testAnchorPoint() {
        AnchorPoint anchorPoint = this.styleFactory.createAnchorPoint((Expression)this.filterFactory.literal(1), (Expression)this.filterFactory.literal(2));
        AnchorPoint clone = (AnchorPoint)((Cloneable)anchorPoint).clone();
        StyleObjectTest.assertClone(anchorPoint, clone);
        AnchorPoint other = this.styleFactory.createAnchorPoint((Expression)this.filterFactory.literal(3), (Expression)this.filterFactory.literal(4));
        StyleObjectTest.assertEqualsContract(clone, other, anchorPoint);
    }

    @Test
    public void testDisplacement() {
        Displacement displacement = this.styleFactory.createDisplacement((Expression)this.filterFactory.literal(1), (Expression)this.filterFactory.literal(2));
        Displacement clone = (Displacement)((Cloneable)displacement).clone();
        StyleObjectTest.assertClone(displacement, clone);
        Displacement other = this.styleFactory.createDisplacement((Expression)this.filterFactory.literal(3), (Expression)this.filterFactory.literal(4));
        StyleObjectTest.assertEqualsContract(clone, other, displacement);
    }

    @Test
    public void testPointPlacement() {
        PointPlacement pointPl = this.styleFactory.getDefaultPointPlacement();
        PointPlacement clone = (PointPlacement)((Cloneable)pointPl).clone();
        StyleObjectTest.assertClone(pointPl, clone);
        PointPlacement other = (PointPlacement)((Cloneable)pointPl).clone();
        other.setRotation((Expression)this.filterFactory.literal(274.0));
        StyleObjectTest.assertEqualsContract(clone, other, pointPl);
    }

    @Test
    public void testPolygonSymbolizer() {
        PolygonSymbolizer polygonSymb = this.styleFactory.createPolygonSymbolizer();
        PolygonSymbolizer clone = (PolygonSymbolizer)((Cloneable)polygonSymb).clone();
        StyleObjectTest.assertClone(polygonSymb, clone);
        PolygonSymbolizer notEq = this.styleFactory.getDefaultPolygonSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, polygonSymb);
    }

    @Test
    public void testLineSymbolizer() {
        LineSymbolizer lineSymb = this.styleFactory.createLineSymbolizer();
        LineSymbolizer clone = (LineSymbolizer)((Cloneable)lineSymb).clone();
        StyleObjectTest.assertClone(lineSymb, clone);
        LineSymbolizer notEq = this.styleFactory.getDefaultLineSymbolizer();
        notEq.setGeometryPropertyName("something_else");
        StyleObjectTest.assertEqualsContract(clone, notEq, lineSymb);
    }

    @Test
    public void testGraphic() {
        Graphic graphic = this.styleFactory.getDefaultGraphic();
        graphic.graphicalSymbols().add(this.styleFactory.getDefaultMark());
        Graphic clone = (Graphic)((Cloneable)graphic).clone();
        StyleObjectTest.assertClone(graphic, clone);
        StyleObjectTest.assertEqualsContract(clone, graphic);
        Assert.assertEquals((long)clone.graphicalSymbols().size(), (long)graphic.graphicalSymbols().size());
        Graphic notEq = this.styleFactory.getDefaultGraphic();
        StyleObjectTest.assertEqualsContract(clone, notEq, graphic);
    }

    @Test
    public void testExternalGraphic() {
        ExternalGraphic exGraphic = this.styleFactory.createExternalGraphic("http://somewhere", "image/png");
        ExternalGraphic clone = (ExternalGraphic)((Cloneable)exGraphic).clone();
        StyleObjectTest.assertClone(exGraphic, clone);
        ExternalGraphic notEq = this.styleFactory.createExternalGraphic("http://somewhereelse", "image/jpeg");
        StyleObjectTest.assertEqualsContract(clone, notEq, exGraphic);
        ExternalGraphic notEq2 = (ExternalGraphic)((Cloneable)clone).clone();
        notEq2.setFormat("image/jpeg");
        StyleObjectTest.assertEqualsContract(clone, notEq2, exGraphic);
    }

    @Test
    public void testMark() {
        Mark mark = this.styleFactory.getCircleMark();
        Mark clone = (Mark)((Cloneable)mark).clone();
        StyleObjectTest.assertClone(mark, clone);
        Mark notEq = this.styleFactory.getStarMark();
        StyleObjectTest.assertEqualsContract(clone, notEq, mark);
    }

    @Test
    public void testFill() {
        Fill fill = this.styleFactory.getDefaultFill();
        Fill clone = (Fill)((Cloneable)fill).clone();
        StyleObjectTest.assertClone(fill, clone);
        Fill notEq = this.styleFactory.createFill((Expression)this.filterFactory.literal((Object)"#FF0000"));
        StyleObjectTest.assertEqualsContract(clone, notEq, fill);
    }

    @Test
    public void testStroke() {
        Stroke stroke = this.styleFactory.getDefaultStroke();
        DuplicatingStyleVisitor duplicate = new DuplicatingStyleVisitor(this.styleFactory);
        stroke.accept((StyleVisitor)duplicate);
        Stroke clone = (Stroke)duplicate.getCopy();
        StyleObjectTest.assertClone(stroke, clone);
        Stroke notEq = this.styleFactory.createStroke((Expression)this.filterFactory.literal((Object)"#FF0000"), (Expression)this.filterFactory.literal(10));
        StyleObjectTest.assertEqualsContract(clone, notEq, stroke);
        Stroke dashArray = this.styleFactory.getDefaultStroke();
        dashArray.setDashArray(new float[]{1.0f, 2.0f, 3.0f});
        dashArray.accept((StyleVisitor)duplicate);
        Stroke dashArray2 = (Stroke)duplicate.getCopy();
        StyleObjectTest.assertEqualsContract(dashArray, dashArray2);
    }

    private static void assertClone(Object real, Object clone) {
        Assert.assertNotNull((String)"Real was null", (Object)real);
        Assert.assertNotNull((String)"Clone was null", (Object)clone);
        Assert.assertNotSame((String)(real.getClass().getName() + " was not cloned"), (Object)real, (Object)clone);
    }

    private static void assertEqualsContract(Object controlEqual, Object controlNe, Object test) {
        Assert.assertNotNull((Object)controlEqual);
        Assert.assertNotNull((Object)controlNe);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((String)"Reflexivity test failed", (Object)test, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)controlEqual, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)test, (Object)controlEqual);
        Assert.assertNotEquals((String)"Symmetry test failed", (Object)test, (Object)controlNe);
        Assert.assertNotEquals((String)"Symmetry test failed", (Object)controlNe, (Object)test);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlEqual, (Object)controlNe);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)test, (Object)controlNe);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlNe, (Object)controlEqual);
        Assert.assertNotEquals((String)"Transitivity test failed", (Object)controlNe, (Object)test);
        Assert.assertNotEquals((String)"Non-null test failed", null, (Object)test);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        Assert.assertEquals((String)"Equal objects should return equal hashcodes", (long)controlEqHash, (long)testHash);
    }

    private static void assertEqualsContract(Object controlEqual, Object test) {
        Assert.assertNotNull((Object)controlEqual);
        Assert.assertNotNull((Object)test);
        Assert.assertEquals((String)"Reflexivity test failed", (Object)test, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)controlEqual, (Object)test);
        Assert.assertEquals((String)"Symmetry test failed", (Object)test, (Object)controlEqual);
        Assert.assertNotEquals((String)"Non-null test failed", null, (Object)test);
        int controlEqHash = controlEqual.hashCode();
        int testHash = test.hashCode();
        Assert.assertEquals((String)"Equal objects should return equal hashcodes", (long)controlEqHash, (long)testHash);
    }

    @Test
    public void testFeatureStyleImplCopy() throws Exception {
        FeatureTypeStyleImpl fts = new FeatureTypeStyleImpl();
        Assert.assertNull((Object)fts.getTransformation());
        Assert.assertNull((Object)fts.getOnlineResource());
        OnLineResourceImpl impl = new OnLineResourceImpl();
        Literal style = this.filterFactory.literal((Object)"square");
        fts.setTransformation((Expression)style);
        fts.setOnlineResource((OnLineResource)impl);
        Assert.assertEquals((Object)fts.getTransformation(), (Object)this.filterFactory.literal((Object)"square"));
        Assert.assertEquals((Object)fts.getOnlineResource(), (Object)new OnLineResourceImpl());
        FeatureTypeStyleImpl fts2 = new FeatureTypeStyleImpl((FeatureTypeStyle)fts);
        Assert.assertEquals((Object)fts.getTransformation(), (Object)fts2.getTransformation());
        Assert.assertEquals((Object)fts.getOnlineResource(), (Object)fts2.getOnlineResource());
    }
}

