/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.PointSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.Symbolizer;
import org.geotools.feature.NameImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.StyleBuilder;
import org.junit.Assert;
import org.junit.Test;

public class FeatureTypeStyleImplTest {
    @Test
    public void testCloneMethod() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        PointSymbolizer symbolizer = sb.createPointSymbolizer();
        Rule rule = sb.createRule((Symbolizer)symbolizer);
        FeatureTypeStyleImpl original = new FeatureTypeStyleImpl(new Rule[]{rule});
        Assert.assertNotNull((String)"orig: rules must not be null", (Object)original.rules());
        Assert.assertEquals((String)"orig: one rule expected", (long)1L, (long)original.rules().size());
        original.featureTypeNames().add(new NameImpl("MyFeatureType1"));
        original.featureTypeNames().add(new NameImpl("MyFeatureType2"));
        Assert.assertNotNull((String)"orig: featureTypeNames must not be null", (Object)original.featureTypeNames());
        Assert.assertEquals((String)"orig: two featureTypeNames expected", (long)2L, (long)original.featureTypeNames().size());
        original.semanticTypeIdentifiers().add(SemanticType.POINT);
        original.semanticTypeIdentifiers().add(SemanticType.LINE);
        original.semanticTypeIdentifiers().add(SemanticType.POLYGON);
        Assert.assertNotNull((String)"orig: semanticTypeIdentifiers must not be null", (Object)original.semanticTypeIdentifiers());
        Assert.assertEquals((String)"orig: three semanticTypeIdentifiers expected", (long)3L, (long)original.semanticTypeIdentifiers().size());
        FeatureTypeStyle clone = (FeatureTypeStyle)original.clone();
        Assert.assertNotNull((String)"clone: rules must not be null", (Object)clone.rules());
        Assert.assertEquals((String)"clone: one rule expected", (long)1L, (long)clone.rules().size());
        Assert.assertNotSame((String)"clone: rules collection should have been cloned", (Object)clone.rules(), (Object)original.rules());
        Assert.assertNotNull((String)"clone: featureTypeNames must not be null", (Object)clone.featureTypeNames());
        Assert.assertEquals((String)"clone: two featureTypeNames expected", (long)2L, (long)clone.featureTypeNames().size());
        Assert.assertNotSame((String)"clone: semanticTypeIdentifiers collection should have been cloned", (Object)clone.featureTypeNames(), (Object)original.featureTypeNames());
        Assert.assertNotNull((String)"clone: semanticTypeIdentifiers must not be null", (Object)clone.semanticTypeIdentifiers());
        Assert.assertEquals((String)"clone: three semanticTypeIdentifiers expected", (long)3L, (long)clone.semanticTypeIdentifiers().size());
        Assert.assertNotSame((String)"clone: semanticTypeIdentifiers collection should have been cloned", (Object)clone.semanticTypeIdentifiers(), (Object)original.semanticTypeIdentifiers());
    }
}

