/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.List;
import java.util.stream.Collectors;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class DuplicateFilterVisitorTest {
    private FilterFactory fac;

    @Before
    public void setUp() throws Exception {
        this.fac = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
    }

    @Test
    public void testLogicFilterDuplication() throws IllegalFilterException {
        PropertyIsGreaterThan greater = this.fac.greater((Expression)this.fac.literal(2), (Expression)this.fac.literal(1));
        PropertyIsLessThan less = this.fac.less((Expression)this.fac.literal(3), (Expression)this.fac.literal(4));
        And and = this.fac.and((Filter)greater, (Filter)less);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor();
        Filter newFilter = (Filter)and.accept((FilterVisitor)visitor, (Object)this.fac);
        Assert.assertNotNull((Object)newFilter);
        Assert.assertEquals((Object)and, (Object)newFilter);
    }

    @Test
    public void testOptimizationExample() {
        Add add = this.fac.add((Expression)this.fac.literal(1), (Expression)this.fac.literal(2));
        class Optimization
        extends DuplicatingFilterVisitor {
            Optimization() {
            }

            public Object visit(Add expression, Object extraData) {
                Expression expr1 = expression.getExpression1();
                Expression expr2 = expression.getExpression2();
                if (expr1 instanceof Literal && expr2 instanceof Literal) {
                    Double number1 = (Double)expr1.evaluate(null, Double.class);
                    Double number2 = (Double)expr2.evaluate(null, Double.class);
                    return this.ff.literal(number1 + number2);
                }
                return super.visit(expression, extraData);
            }
        }
        Expression modified = (Expression)add.accept((ExpressionVisitor)new Optimization(), null);
        Assert.assertTrue((boolean)(modified instanceof Literal));
    }

    @Test
    public void testNotFilter() {
        PropertyIsLike like = this.fac.like((Expression)this.fac.property("stringProperty"), "ab*");
        Not not = this.fac.not((Filter)like);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(this.fac);
        Not clone = (Not)not.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)not, (Object)clone);
        Assert.assertNotSame((Object)not, (Object)clone);
        Assert.assertNotSame((Object)like, (Object)clone.getFilter());
    }

    @Test
    public void testPreservedNamespaceContext() {
        NamespaceSupport nsContext = new NamespaceSupport();
        nsContext.declarePrefix("f", "http://feature.example.org");
        PropertyName geometry = this.fac.property("f:name", nsContext);
        BBOX bbox = this.fac.bbox((Expression)geometry, 0.0, 0.0, 1.0, 1.0, "EPSG:4326");
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(this.fac);
        BBOX clone = (BBOX)bbox.accept((FilterVisitor)visitor, null);
        Assert.assertEquals((Object)bbox, (Object)clone);
        Assert.assertNotSame((Object)bbox, (Object)clone);
        Assert.assertSame((Object)nsContext, (Object)((PropertyName)clone.getExpression1()).getNamespaceContext());
    }

    @Test
    public void testNativeFilterIsDuplicated() {
        BBOX boundingBoxFilter = this.fac.bbox("geometry", -5.0, -5.0, 5.0, 5.0, DefaultGeographicCRS.WGS84.toString());
        NativeFilter nativeFilter = this.fac.nativeFilter("SOME NATIVE FILTER");
        And filter = this.fac.and((Filter)boundingBoxFilter, (Filter)nativeFilter);
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(this.fac);
        Filter duplicated = (Filter)filter.accept((FilterVisitor)visitor, null);
        MatcherAssert.assertThat((Object)duplicated, (Matcher)Matchers.instanceOf(And.class));
        And andFilter = (And)duplicated;
        MatcherAssert.assertThat((Object)andFilter.getChildren().size(), (Matcher)Matchers.is((Object)2));
        List found = andFilter.getChildren().stream().filter(child -> child instanceof NativeFilter).collect(Collectors.toList());
        MatcherAssert.assertThat((Object)found.size(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)((NativeFilter)found.get(0)).getNative(), (Matcher)Matchers.is((Object)"SOME NATIVE FILTER"));
    }
}

