/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.filter.FilterFactoryImpl;
import org.junit.Assert;
import org.junit.Test;

public class ListFunctionsTest {
    FilterFactoryImpl ff = new FilterFactoryImpl();

    @Test
    public void testSize() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Function exp = this.ff.function("size", (Expression)this.ff.property("."));
        Object value = exp.evaluate(list);
        Assert.assertTrue((boolean)(value instanceof Integer));
        Assert.assertEquals((long)4L, (long)((Integer)value).intValue());
    }

    @Test
    public void testLitem() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Function exp = this.ff.function("litem", (Expression)this.ff.property("."), (Expression)this.ff.literal(2));
        Object value = exp.evaluate(list);
        Assert.assertTrue((boolean)(value instanceof Integer));
        Assert.assertEquals((long)3L, (long)((Integer)value).intValue());
    }

    @Test
    public void testLapply() {
        List<Integer> list = Arrays.asList(1, 2, 3, 4);
        Function exp = this.ff.function("lapply", (Expression)this.ff.property("."), (Expression)this.ff.multiply((Expression)this.ff.property("."), (Expression)this.ff.literal(2)));
        Object value = exp.evaluate(list);
        Assert.assertTrue((boolean)(value instanceof List));
        Assert.assertEquals(Arrays.asList(2.0, 4.0, 6.0, 8.0), (Object)value);
    }
}

