/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;

public class MultiFilterTest {
    private FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);

    @Test
    public void testFactoryAndGetter() {
        PropertyName expr1 = this.fac.property("foo");
        PropertyName expr2 = this.fac.property("bar");
        PropertyName expr3 = this.fac.property("noo");
        BBOX filter = this.fac.bbox((Expression)expr1, (BoundingBox)new ReferencedEnvelope());
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.beyond((Expression)expr1, (Expression)expr2, 0.1, "");
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.beyond((Expression)expr1, (Expression)expr2, 0.1, "");
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.contains((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.crosses((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.disjoint((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.dwithin((Expression)expr1, (Expression)expr2, 0.1, "");
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.equal((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.intersects((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.overlaps((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.touches((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.within((Expression)expr1, (Expression)expr2);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.equal((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.less((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.greater((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.lessOrEqual((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.greaterOrEqual((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.notEqual((Expression)expr1, (Expression)expr2, false);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.between((Expression)expr1, (Expression)expr2, (Expression)expr3);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.like((Expression)expr1, "");
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ANY);
        filter = this.fac.bbox((Expression)expr1, (BoundingBox)new ReferencedEnvelope(), MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.beyond((Expression)expr1, (Expression)expr2, 0.1, "", MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.beyond((Expression)expr1, (Expression)expr2, 0.1, "", MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.contains((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.crosses((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.disjoint((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.dwithin((Expression)expr1, (Expression)expr2, 0.1, "", MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.equal((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.intersects((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.overlaps((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.touches((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.within((Expression)expr1, (Expression)expr2, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.equal((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.less((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.greater((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.lessOrEqual((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.greaterOrEqual((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.notEqual((Expression)expr1, (Expression)expr2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
        filter = this.fac.between((Expression)expr1, (Expression)expr2, (Expression)expr3, MultiValuedFilter.MatchAction.ALL);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ALL);
        filter = this.fac.like((Expression)expr1, "", "*", "?", "\\", false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertEquals((Object)filter.getMatchAction(), (Object)MultiValuedFilter.MatchAction.ONE);
    }

    @Test
    public void testCompareStringOperators_Any() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo-1");
        list.add("foo-2");
        list.add("foo-3");
        list.add("blah-blah");
        LiteralExpressionImpl e = new LiteralExpressionImpl(list);
        LiteralExpressionImpl empty = new LiteralExpressionImpl(new ArrayList());
        PropertyIsEqualTo filter = this.fac.equals((Expression)e, (Expression)new LiteralExpressionImpl("foo-2"));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)new LiteralExpressionImpl("foo-1"), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)e, (Expression)new LiteralExpressionImpl("foo-3"));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)new LiteralExpressionImpl("blah"), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)empty, (Expression)new LiteralExpressionImpl("blah"));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)new LiteralExpressionImpl("blah"), (Expression)empty);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl("blah"));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl("foo-2"), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e, "foo*");
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e, "blah*");
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e, "foox*");
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)empty, "*");
        Assert.assertFalse((boolean)filter.evaluate(null));
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("foo-4");
        list2.add("foo-5");
        list2.add("foo-6");
        filter = this.fac.equals((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        list2.add("blah-blah");
        filter = this.fac.equals((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        list2 = new ArrayList();
        list2.add("foo-1");
        list2.add("foo-2");
        list2.add("foo-3");
        list2.add("blah-blah");
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        list = new ArrayList();
        list.add("foo-1");
        list.add("foo-1");
        list.add("foo-1");
        e = new LiteralExpressionImpl(list);
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl("foo-1"));
        Assert.assertFalse((boolean)filter.evaluate(null));
        list2 = new ArrayList();
        list2.add("foo-1");
        list2.add("foo-1");
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl(list2));
        Assert.assertFalse((boolean)filter.evaluate(null));
    }

    @Test
    public void testCompareStringOperators_All() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo-1");
        list.add("foo-2");
        list.add("foo-3");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("fOo-2");
        list2.add("foO-2");
        list2.add("Foo-2");
        LiteralExpressionImpl e1 = new LiteralExpressionImpl(list);
        LiteralExpressionImpl e2 = new LiteralExpressionImpl(list2);
        PropertyIsEqualTo filter = this.fac.equal((Expression)e1, (Expression)new LiteralExpressionImpl("foo-2"), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl("foo-2"), (Expression)e2, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e1, (Expression)new LiteralExpressionImpl("blah"), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl("foo-2"), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e1, "foo-*", "*", "?", "\\", false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e1, "*-1", "*", "?", "\\", false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
    }

    @Test
    public void testCompareStringOperators_One() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo-1");
        list.add("foo-2");
        list.add("foo-3");
        ArrayList<String> list2 = new ArrayList<String>();
        list2.add("Foo-1");
        list2.add("fOo-2");
        list2.add("foO-2");
        list2.add("Foo-2");
        LiteralExpressionImpl e1 = new LiteralExpressionImpl(list);
        LiteralExpressionImpl e2 = new LiteralExpressionImpl(list2);
        PropertyIsEqualTo filter = this.fac.equal((Expression)e1, (Expression)new LiteralExpressionImpl("foo-2"), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl("foo-2"), (Expression)e2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e1, (Expression)new LiteralExpressionImpl("blah"), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl("foo-2"), (Expression)e2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e1, "foo-*", "*", "?", "\\", false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.like((Expression)e1, "*-1", "*", "?", "\\", false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
    }

    @Test
    public void testCompareNumberOperators_Any() {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(35.2);
        list.add(202.3);
        list.add(201.7);
        list.add(10000.5);
        LiteralExpressionImpl e = new LiteralExpressionImpl(list);
        LiteralExpressionImpl empty = new LiteralExpressionImpl(new ArrayList());
        PropertyIsEqualTo filter = this.fac.equals((Expression)e, (Expression)new LiteralExpressionImpl(201.7));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equals((Expression)new LiteralExpressionImpl(202.3), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e, (Expression)new LiteralExpressionImpl(10.7));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl(888.8), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e, (Expression)new LiteralExpressionImpl(9999));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e, (Expression)new LiteralExpressionImpl(99999));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(50), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(34), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e, (Expression)new LiteralExpressionImpl(50));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e, (Expression)new LiteralExpressionImpl(34));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(9999), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(99999), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e, (Expression)new LiteralExpressionImpl(10000.5));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e, (Expression)new LiteralExpressionImpl(10001));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(35.2), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(35), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e, (Expression)new LiteralExpressionImpl(35.2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e, (Expression)new LiteralExpressionImpl(35));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(10000.5), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(10001), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e, (Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(36));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e, (Expression)new LiteralExpressionImpl(200), (Expression)new LiteralExpressionImpl(300));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e, (Expression)new LiteralExpressionImpl(36), (Expression)new LiteralExpressionImpl(201));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e, (Expression)new LiteralExpressionImpl(203), (Expression)new LiteralExpressionImpl(9999));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)new LiteralExpressionImpl(36), (Expression)e, (Expression)new LiteralExpressionImpl(37));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)new LiteralExpressionImpl(0), (Expression)e, (Expression)new LiteralExpressionImpl(100000));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(0), (Expression)e);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)new LiteralExpressionImpl(10001), (Expression)new LiteralExpressionImpl(0), (Expression)e);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)empty, (Expression)new LiteralExpressionImpl(0), (Expression)new LiteralExpressionImpl(10001));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)new LiteralExpressionImpl(10001), (Expression)new LiteralExpressionImpl(0), (Expression)empty);
        Assert.assertFalse((boolean)filter.evaluate(null));
    }

    @Test
    public void testCompareNumberOperators_All() {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(35.2);
        list.add(202.3);
        list.add(201.7);
        list.add(10000.5);
        ArrayList<Double> list2 = new ArrayList<Double>();
        list2.add(35.2);
        list2.add(35.2);
        list2.add(35.2);
        LiteralExpressionImpl e1 = new LiteralExpressionImpl(list);
        LiteralExpressionImpl e2 = new LiteralExpressionImpl(list2);
        PropertyIsEqualTo filter = this.fac.equal((Expression)e1, (Expression)new LiteralExpressionImpl(35.2), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(35.2), (Expression)e2, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e1, (Expression)new LiteralExpressionImpl(201.7), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl(55), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e1, (Expression)new LiteralExpressionImpl(9999), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e1, (Expression)new LiteralExpressionImpl(32), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(100000000), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(700), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e1, (Expression)new LiteralExpressionImpl(100000000), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e1, (Expression)new LiteralExpressionImpl(9999), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(32), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(700), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(35.2), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(201.7), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(10000.5), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(201.7), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(10000.5), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(201.7), false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(35.2), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(201.7), (Expression)e1, false, MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e1, (Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(300), MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e1, (Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(10000000), MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
    }

    @Test
    public void testCompareNumberOperators_One() {
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(35.2);
        list.add(202.3);
        list.add(201.7);
        list.add(10000.5);
        ArrayList<Double> list2 = new ArrayList<Double>();
        list2.add(35.2);
        list2.add(35.2);
        list2.add(202.3);
        LiteralExpressionImpl e1 = new LiteralExpressionImpl(list);
        LiteralExpressionImpl e2 = new LiteralExpressionImpl(list2);
        PropertyIsEqualTo filter = this.fac.equal((Expression)e1, (Expression)new LiteralExpressionImpl(35.2), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(35.2), (Expression)e2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)e1, (Expression)new LiteralExpressionImpl(35.2), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.notEqual((Expression)new LiteralExpressionImpl(35.2), (Expression)e2, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e1, (Expression)new LiteralExpressionImpl(100), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)e1, (Expression)new LiteralExpressionImpl(9000), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(40), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greater((Expression)new LiteralExpressionImpl(700), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e1, (Expression)new LiteralExpressionImpl(40), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)e1, (Expression)new LiteralExpressionImpl(700), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(9000), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.less((Expression)new LiteralExpressionImpl(100), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(10000.5), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(201.7), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(35.2), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.greaterOrEqual((Expression)new LiteralExpressionImpl(10001), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(35.2), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)e1, (Expression)new LiteralExpressionImpl(10001), false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(10000.5), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.lessOrEqual((Expression)new LiteralExpressionImpl(201.7), (Expression)e1, false, MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e1, (Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(300), MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.between((Expression)e1, (Expression)new LiteralExpressionImpl(34), (Expression)new LiteralExpressionImpl(36), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
    }

    @Test
    public void testGeometries_Any() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Coordinate[] coords1 = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        Polygon geom1 = gf.createPolygon(gf.createLinearRing(coords1), new LinearRing[0]);
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom2 = gf.createPolygon(gf.createLinearRing(coords2), new LinearRing[0]);
        Coordinate[] coords3 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(11.0, 12.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom3 = gf.createPolygon(gf.createLinearRing(coords3), new LinearRing[0]);
        Coordinate[] coords4 = new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(60.0, 30.0), new Coordinate(110.0, 120.0), new Coordinate(30.0, 70.0), new Coordinate(20.0, 20.0)};
        Polygon geom4 = gf.createPolygon(gf.createLinearRing(coords4), new LinearRing[0]);
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        list.add(geom4);
        Overlaps filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list));
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.disjoint((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list));
        Assert.assertTrue((boolean)filter.evaluate(null));
        list.add(geom3);
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.within((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertFalse((boolean)filter.evaluate(null));
        list.add(geom2);
        filter = this.fac.within((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertFalse((boolean)filter.evaluate(null));
        list.add(geom1);
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1));
        Assert.assertTrue((boolean)filter.evaluate(null));
        list = new ArrayList();
        list.add(geom3);
        list.add(geom2);
        ArrayList<Polygon> list2 = new ArrayList<Polygon>();
        list2.add(geom1);
        list2.add(geom2);
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.intersects((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl(list2));
        Assert.assertTrue((boolean)filter.evaluate(null));
    }

    @Test
    public void testGeometries_One() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Coordinate[] coords1 = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        Polygon geom1 = gf.createPolygon(gf.createLinearRing(coords1), new LinearRing[0]);
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom2 = gf.createPolygon(gf.createLinearRing(coords2), new LinearRing[0]);
        Coordinate[] coords3 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(11.0, 12.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom3 = gf.createPolygon(gf.createLinearRing(coords3), new LinearRing[0]);
        Coordinate[] coords4 = new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(60.0, 30.0), new Coordinate(110.0, 120.0), new Coordinate(30.0, 70.0), new Coordinate(20.0, 20.0)};
        Polygon geom4 = gf.createPolygon(gf.createLinearRing(coords4), new LinearRing[0]);
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        list.add(geom4);
        Equals filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom4), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.disjoint((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        list.add(geom3);
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom4), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.within((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        list.add(geom2);
        filter = this.fac.within((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertFalse((boolean)filter.evaluate(null));
        list.add(geom1);
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ONE);
        Assert.assertTrue((boolean)filter.evaluate(null));
    }

    @Test
    public void testGeometries_All() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel());
        Coordinate[] coords1 = new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(0.0, 0.0)};
        Polygon geom1 = gf.createPolygon(gf.createLinearRing(coords1), new LinearRing[0]);
        Coordinate[] coords2 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(6.0, 7.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom2 = gf.createPolygon(gf.createLinearRing(coords2), new LinearRing[0]);
        Coordinate[] coords3 = new Coordinate[]{new Coordinate(2.0, 2.0), new Coordinate(6.0, 0.0), new Coordinate(11.0, 12.0), new Coordinate(0.0, 7.0), new Coordinate(2.0, 2.0)};
        Polygon geom3 = gf.createPolygon(gf.createLinearRing(coords3), new LinearRing[0]);
        Coordinate[] coords4 = new Coordinate[]{new Coordinate(20.0, 20.0), new Coordinate(60.0, 30.0), new Coordinate(110.0, 120.0), new Coordinate(30.0, 70.0), new Coordinate(20.0, 20.0)};
        Polygon geom4 = gf.createPolygon(gf.createLinearRing(coords4), new LinearRing[0]);
        ArrayList<Polygon> list = new ArrayList<Polygon>();
        list.add(geom4);
        Equals filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom4), MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.disjoint((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list), MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
        list.add(geom3);
        filter = this.fac.equal((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom4), MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.overlaps((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        filter = this.fac.within((Expression)new LiteralExpressionImpl(list), (Expression)new LiteralExpressionImpl((Object)geom1), MultiValuedFilter.MatchAction.ALL);
        Assert.assertFalse((boolean)filter.evaluate(null));
        list.remove(geom4);
        list.add(geom2);
        filter = this.fac.intersects((Expression)new LiteralExpressionImpl((Object)geom1), (Expression)new LiteralExpressionImpl(list), MultiValuedFilter.MatchAction.ALL);
        Assert.assertTrue((boolean)filter.evaluate(null));
    }
}

