/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.Types;
import org.junit.Assert;
import org.junit.Test;

public class TypesTest {
    @Test
    public void testAttributeBuilder() {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory();
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.binding(Integer.class);
        builder.minOccurs(1).maxOccurs(1);
        builder.defaultValue((Object)0);
        builder.name("percent").description("Percent between 0 and 100");
        builder.restriction((Filter)ff.greaterOrEqual((Expression)ff.property("."), (Expression)ff.literal(0))).restriction((Filter)ff.lessOrEqual((Expression)ff.property("."), (Expression)ff.literal(100)));
        AttributeType PERCENT = builder.buildType();
        builder.minOccurs(1).maxOccurs(1);
        builder.defaultValue((Object)0);
        builder.name("percent").description("Percent between 0 and 100");
        AttributeDescriptor a = builder.buildDescriptor("a", PERCENT);
        Assert.assertSame((Object)a.getType(), (Object)PERCENT);
        Assert.assertEquals((Object)a.getDefaultValue(), (Object)0);
        And restrictions = ff.and(PERCENT.getRestrictions());
        Assert.assertTrue((boolean)restrictions.evaluate((Object)50));
        Assert.assertFalse((boolean)restrictions.evaluate((Object)150));
    }

    @Test
    public void testWithoutRestriction() {
        String attributeName = "string";
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, null);
        Assert.assertNotNull((Object)feature);
    }

    @Test
    public void testRestrictionCheck() {
        FilterFactory fac = CommonFactoryFinder.getFilterFactory(null);
        String attributeName = "string";
        PropertyIsEqualTo filter = fac.equals((Expression)fac.property("."), (Expression)fac.literal((Object)"Value"));
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("test");
        builder.restriction((Filter)filter).minOccurs(1).nillable(false).add(attributeName, String.class);
        SimpleFeatureType featureType = builder.buildFeatureType();
        SimpleFeature feature = SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"Value"}, null);
        Assert.assertNotNull((Object)feature);
        Assert.assertTrue((String)"valid", (boolean)Types.isValid((Attribute)feature));
        feature.setAttribute("string", null);
        Assert.assertFalse((String)"invalid", (boolean)Types.isValid((Attribute)feature));
    }

    @Test
    public void testAssertNamedAssignable() {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName("Test");
        builder.add("name", String.class);
        builder.add("age", Double.class);
        SimpleFeatureType test = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("age", Double.class);
        builder.add("name", String.class);
        SimpleFeatureType test2 = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("name", String.class);
        SimpleFeatureType test3 = builder.buildFeatureType();
        builder.setName("Test");
        builder.add("name", String.class);
        builder.add("distance", Double.class);
        SimpleFeatureType test4 = builder.buildFeatureType();
        Types.assertNameAssignable((FeatureType)test, (FeatureType)test);
        Types.assertNameAssignable((FeatureType)test, (FeatureType)test2);
        Types.assertNameAssignable((FeatureType)test2, (FeatureType)test);
        try {
            Types.assertNameAssignable((FeatureType)test, (FeatureType)test3);
            Assert.fail((String)"Expected assertNameAssignable to fail as age is not covered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Types.assertOrderAssignable((SimpleFeatureType)test, (SimpleFeatureType)test4);
    }
}

