/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.BasicFeatureTypes;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class FeatureTypeTest
extends DataTestCase {
    static Set<Class<?>> immutable = new HashSet();

    @Test
    public void testAbstractType() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("AbstractThing");
        tb.setAbstract(true);
        tb.setNamespaceURI(new URI("http://www.nowhereinparticular.net"));
        SimpleFeatureType abstractType = tb.buildFeatureType();
        tb.setName("AbstractType2");
        tb.setSuperType(abstractType);
        tb.add("X", String.class);
        SimpleFeatureType abstractType2 = tb.buildFeatureType();
        Assert.assertTrue((boolean)abstractType.isAbstract());
        Assert.assertTrue((boolean)abstractType2.isAbstract());
        Assert.assertTrue((String)"abstractType2 --|> abstractType", (boolean)FeatureTypes.isDecendedFrom((FeatureType)abstractType2, (FeatureType)abstractType));
        Assert.assertFalse((String)"abstractType2 !--|> abstractType", (boolean)FeatureTypes.isDecendedFrom((FeatureType)abstractType, (FeatureType)abstractType2));
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)abstractType, (Object[])new Object[0], null);
            Assert.fail((String)"abstract type allowed create");
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
        try {
            SimpleFeatureBuilder.build((SimpleFeatureType)abstractType2, (Object[])new Object[0], null);
            Assert.fail((String)"abstract type allowed create");
        }
        catch (IllegalArgumentException | UnsupportedOperationException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testEquals() throws Exception {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("Thing");
        tb.setNamespaceURI("http://www.nowhereinparticular.net");
        tb.add("X", String.class);
        SimpleFeatureType ft = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("Thing");
        tb.setNamespaceURI("http://www.nowhereinparticular.net");
        tb.add("X", String.class);
        SimpleFeatureType ft2 = tb.buildFeatureType();
        Assert.assertEquals((Object)ft, (Object)ft2);
        tb.setName("Thingee");
        Assert.assertNotEquals((Object)ft, (Object)tb.buildFeatureType());
        tb.init(ft);
        tb.setNamespaceURI("http://www.somewhereelse.net");
        Assert.assertNotEquals((Object)ft, (Object)tb.buildFeatureType());
        Assert.assertNotEquals((Object)ft, null);
    }

    @Test
    public void testCopyFeature() throws Exception {
        SimpleFeature feature = this.lakeFeatures[0];
        this.assertDuplicate("feature", feature, SimpleFeatureBuilder.copy((SimpleFeature)feature));
    }

    @Test
    public void testAncestors() throws Exception {
        URI uri = new URI("http://www.geotools.org/example");
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName("A");
        tb.setNamespaceURI(uri);
        SimpleFeatureType typeA = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("B");
        tb.setNamespaceURI(uri);
        tb.setSuperType(typeA);
        tb.add("b", String.class);
        SimpleFeatureType typeB = tb.buildFeatureType();
        tb = new SimpleFeatureTypeBuilder();
        tb.setName("C");
        tb.setNamespaceURI(uri);
        tb.setSuperType(typeB);
        tb.add("c", Integer.class);
        SimpleFeatureType typeC = tb.buildFeatureType();
        Assert.assertEquals((String)"Ancestors of Feature, nearest first", Collections.emptyList(), (Object)FeatureTypes.getAncestors((FeatureType)BasicFeatureTypes.FEATURE));
        Assert.assertEquals((String)"Ancestors of A, nearest first", List.of(BasicFeatureTypes.FEATURE), (Object)FeatureTypes.getAncestors((FeatureType)typeA));
        Assert.assertEquals((String)"Ancestors of B, nearest first", List.of(typeA, BasicFeatureTypes.FEATURE), (Object)FeatureTypes.getAncestors((FeatureType)typeB));
        Assert.assertEquals((String)"Ancestors of C, nearest first", List.of(typeB, typeA, BasicFeatureTypes.FEATURE), (Object)FeatureTypes.getAncestors((FeatureType)typeC));
    }

    @Test
    public void testDeepCopy() throws Exception {
        String str = "FooBar";
        Integer i = 3;
        Float f = Float.valueOf(3.14f);
        Double d = 3.14159;
        Assert.assertSame((String)"String", (Object)str, (Object)DataUtilities.duplicate((Object)str));
        Assert.assertSame((String)"Integer", (Object)i, (Object)DataUtilities.duplicate((Object)i));
        Assert.assertSame((String)"Float", (Object)f, (Object)DataUtilities.duplicate((Object)f));
        Assert.assertSame((String)"Double", (Object)d, (Object)DataUtilities.duplicate((Object)d));
        Object[] objs = new Object[]{str, i, f, d};
        int[] ints = new int[]{1, 2, 3, 4};
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(str);
        list.add(i);
        list.add(f);
        list.add(d);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("a", str);
        map.put("b", i);
        map.put("c", f);
        map.put("d", d);
        this.assertDuplicate("objs", objs, DataUtilities.duplicate((Object)objs));
        this.assertDuplicate("ints", ints, DataUtilities.duplicate((Object)ints));
        this.assertDuplicate("list", list, DataUtilities.duplicate(list));
        this.assertDuplicate("map", map, DataUtilities.duplicate(map));
        SimpleFeature feature = this.lakeFeatures[0];
        Coordinate coords = new Coordinate(1.0, 3.0);
        Coordinate coords2 = new Coordinate(1.0, 3.0);
        GeometryFactory gf = new GeometryFactory();
        Point point = gf.createPoint(coords);
        Point point2 = gf.createPoint(coords2);
        this.assertDuplicate("jts duplicate", point, point2);
        this.assertDuplicate("feature", feature, DataUtilities.duplicate((Object)feature));
        this.assertDuplicate("point", point, DataUtilities.duplicate((Object)point));
    }

    protected void assertDuplicate(String message, Object expected, Object value) {
        if (expected.getClass().isArray()) {
            int length1 = Array.getLength(expected);
            int length2 = Array.getLength(value);
            Assert.assertEquals((String)message, (long)length1, (long)length2);
            for (int i = 0; i < length1; ++i) {
                this.assertDuplicate(message + "[" + i + "]", Array.get(expected, i), Array.get(value, i));
            }
        } else if (expected instanceof SimpleFeature) {
            this.assertDuplicate(message, ((SimpleFeature)expected).getAttributes(), ((SimpleFeature)value).getAttributes());
        } else {
            Assert.assertEquals((String)message, (Object)expected, (Object)value);
        }
    }

    static {
        immutable.add(String.class);
        immutable.add(Integer.class);
        immutable.add(Double.class);
        immutable.add(Float.class);
    }
}

