/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.geotools.data.util.TemporalConverterFactory;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemporalConverterFactoryTest {
    TemporalConverterFactory factory;

    @Before
    public void setUp() throws Exception {
        this.factory = new TemporalConverterFactory();
    }

    @Test
    public void testStitchInTime() throws Exception {
        Converter converter = this.factory.createConverter(Calendar.class, Date.class, null);
        Calendar calendar = Calendar.getInstance();
        calendar.set(2004, 6, 1);
        for (int i = 1; i <= 12; ++i) {
            calendar.set(5, 1);
            Date date = (Date)converter.convert((Object)calendar, Date.class);
            TemporalConverterFactoryTest.pause();
            Assert.assertNotNull((Object)date);
            Assert.assertEquals((Object)calendar.getTime(), (Object)date);
        }
        calendar.set(2004, 6, 1, 12, 30);
        Date date = (Date)converter.convert((Object)calendar, Date.class);
        TemporalConverterFactoryTest.pause();
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)calendar.getTime(), (Object)date);
    }

    public static void pause() {
        long pause = System.currentTimeMillis() + 15L;
        while (System.currentTimeMillis() < pause) {
            Thread.yield();
        }
    }

    @Test
    public void testCalendarToDate() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, Date.class, null));
        Date date = (Date)this.factory.createConverter(Calendar.class, Date.class, null).convert((Object)calendar, Date.class);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)calendar.getTime(), (Object)date);
    }

    @Test
    public void testCalendarToDateWithMilliseconds() throws Exception {
        Calendar calendar = Calendar.getInstance();
        long offset = 123L;
        calendar.set(14, (int)offset);
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, Date.class, null));
        Date date = (Date)this.factory.createConverter(Calendar.class, Date.class, null).convert((Object)calendar, Date.class);
        Assert.assertNotNull((Object)date);
        Assert.assertEquals((Object)calendar.getTime(), (Object)date);
    }

    @Test
    public void testCalendarToTime() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(11, 17);
        calendar.set(12, 0);
        calendar.set(13, 1);
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, Time.class, null));
        Time time = (Time)this.factory.createConverter(Calendar.class, Time.class, null).convert((Object)calendar, Time.class);
        Assert.assertNotNull((Object)time);
        Calendar cal = (Calendar)calendar.clone();
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 0);
        Assert.assertEquals((long)cal.getTimeInMillis(), (long)time.getTime());
    }

    @Test
    public void testCalendarToTimestamp() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, Timestamp.class, null));
        Timestamp timeStamp = (Timestamp)this.factory.createConverter(Calendar.class, Timestamp.class, null).convert((Object)calendar, Timestamp.class);
        Assert.assertNotNull((Object)timeStamp);
        Assert.assertEquals((Object)new Timestamp(calendar.getTime().getTime()), (Object)timeStamp);
    }

    @Test
    public void testCalendarToTimestampWithMilliseconds() throws Exception {
        Calendar calendar = Calendar.getInstance();
        long offset = 123L;
        calendar.set(14, (int)offset);
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, Timestamp.class, null));
        Calendar calWithMs = (Calendar)calendar.clone();
        Timestamp timeStamp = (Timestamp)this.factory.createConverter(Calendar.class, Timestamp.class, null).convert((Object)calendar, Timestamp.class);
        Assert.assertNotNull((Object)timeStamp);
        Assert.assertEquals((Object)new Timestamp(calWithMs.getTime().getTime()), (Object)timeStamp);
        Assert.assertEquals((Object)new Timestamp(calendar.getTime().getTime()), (Object)timeStamp);
    }

    @Test
    public void testDateToCalendar() throws Exception {
        Date date = new Date();
        Assert.assertNotNull((Object)this.factory.createConverter(Date.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Date.class, Calendar.class, null).convert((Object)date, Calendar.class);
        Assert.assertNotNull((Object)calendar);
        Assert.assertEquals((Object)date, (Object)calendar.getTime());
    }

    @Test
    public void testDateToTime() throws Exception {
        Date date = new Date();
        Assert.assertNotNull((Object)this.factory.createConverter(Date.class, Time.class, null));
        Time time = (Time)this.factory.createConverter(Date.class, Time.class, null).convert((Object)date, Time.class);
        Assert.assertNotNull((Object)time);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(1, 0);
        cal.set(2, 0);
        cal.set(5, 0);
        Assert.assertEquals((long)cal.getTimeInMillis(), (long)time.getTime());
    }

    @Test
    public void testDateToTimestamp() throws Exception {
        Date date = new Date();
        Assert.assertNotNull((Object)this.factory.createConverter(Date.class, Timestamp.class, null));
        Timestamp timeStamp = (Timestamp)this.factory.createConverter(Date.class, Timestamp.class, null).convert((Object)date, Timestamp.class);
        Assert.assertNotNull((Object)timeStamp);
        Assert.assertEquals((Object)new Timestamp(date.getTime()), (Object)timeStamp);
        Hints h = new Hints();
        h.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)Boolean.TRUE);
        Assert.assertNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, h));
        h.put((Object)ConverterFactory.SAFE_CONVERSION, (Object)Boolean.FALSE);
        Assert.assertNotNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, h));
    }

    @Test
    public void testTimeToCalendar() throws Exception {
        Time time = new Time(new Date().getTime());
        Assert.assertNotNull((Object)this.factory.createConverter(Time.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Time.class, Calendar.class, null).convert((Object)time, Calendar.class);
        Assert.assertNotNull((Object)calendar);
        Assert.assertEquals((Object)time, (Object)new Time(calendar.getTime().getTime()));
    }

    @Test
    public void testTimestampToCalendar() throws Exception {
        Timestamp timeStamp = new Timestamp(new Date().getTime());
        Assert.assertNotNull((Object)this.factory.createConverter(Timestamp.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(Timestamp.class, Calendar.class, null).convert((Object)timeStamp, Calendar.class);
        Assert.assertNotNull((Object)calendar);
        Assert.assertEquals((Object)timeStamp, (Object)new Timestamp(calendar.getTime().getTime()));
    }

    @Test
    public void testXMLGregorianCalendarToCalendar() throws Exception {
        XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar("1981-06-20T12:00:00");
        Assert.assertNotNull((Object)this.factory.createConverter(XMLGregorianCalendar.class, Calendar.class, null));
        Calendar calendar = (Calendar)this.factory.createConverter(XMLGregorianCalendar.class, Calendar.class, null).convert((Object)gc, Calendar.class);
        Assert.assertNotNull((Object)calendar);
        Assert.assertEquals((long)1981L, (long)calendar.get(1));
        Assert.assertEquals((long)5L, (long)calendar.get(2));
        Assert.assertEquals((long)20L, (long)calendar.get(5));
        Assert.assertEquals((long)12L, (long)calendar.get(11));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
    }

    @Test
    public void testCalendarToXMLGregorianCalendar() throws Exception {
        Calendar calendar = Calendar.getInstance();
        Assert.assertNotNull((Object)this.factory.createConverter(Calendar.class, XMLGregorianCalendar.class, null));
        XMLGregorianCalendar gc = (XMLGregorianCalendar)this.factory.createConverter(Calendar.class, XMLGregorianCalendar.class, null).convert((Object)calendar, XMLGregorianCalendar.class);
        Assert.assertNotNull((Object)gc);
        GregorianCalendar actual = gc.toGregorianCalendar();
        Assert.assertEquals((long)calendar.get(1), (long)actual.get(1));
        Assert.assertEquals((long)calendar.get(2), (long)actual.get(2));
        Assert.assertEquals((long)calendar.get(5), (long)actual.get(5));
        Assert.assertEquals((long)calendar.get(11), (long)actual.get(11));
        Assert.assertEquals((long)calendar.get(12), (long)actual.get(12));
        Assert.assertEquals((long)calendar.get(13), (long)actual.get(13));
        Assert.assertEquals((long)calendar.get(14), (long)actual.get(14));
    }

    @Test
    public void testXMLGregorianCalendarToDate() throws Exception {
        XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar("1981-06-20T12:00:00");
        Assert.assertNotNull((Object)this.factory.createConverter(XMLGregorianCalendar.class, Date.class, null));
        Date date = (Date)this.factory.createConverter(XMLGregorianCalendar.class, Date.class, null).convert((Object)gc, Date.class);
        Assert.assertNotNull((Object)date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Assert.assertEquals((long)1981L, (long)calendar.get(1));
        Assert.assertEquals((long)5L, (long)calendar.get(2));
        Assert.assertEquals((long)20L, (long)calendar.get(5));
        Assert.assertEquals((long)12L, (long)calendar.get(11));
        Assert.assertEquals((long)0L, (long)calendar.get(12));
        Assert.assertEquals((long)0L, (long)calendar.get(13));
    }

    @Test
    public void testDateToXMLGregorianCalendar() throws Exception {
        Date date = new Date();
        Assert.assertNotNull((Object)this.factory.createConverter(Date.class, XMLGregorianCalendar.class, null));
        XMLGregorianCalendar gc = (XMLGregorianCalendar)this.factory.createConverter(Date.class, XMLGregorianCalendar.class, null).convert((Object)date, XMLGregorianCalendar.class);
        Assert.assertNotNull((Object)gc);
        Assert.assertEquals((Object)date, (Object)gc.toGregorianCalendar().getTime());
    }

    @Test
    public void testTimeZoneToString() throws Exception {
        Converter converter = this.factory.createConverter(TimeZone.class, String.class, null);
        Assert.assertNotNull((Object)converter);
        Assert.assertEquals((Object)TimeZone.getDefault().getID(), (Object)converter.convert((Object)TimeZone.getDefault(), String.class));
        Assert.assertNull((Object)converter.convert(null, String.class));
    }

    @Test
    public void testLongtoDate() throws Exception {
        Converter converter = this.factory.createConverter(Long.class, Date.class, null);
        Assert.assertNotNull((Object)converter);
        Assert.assertNull((Object)converter.convert(null, Date.class));
        Long esriFieldTypeDateVal = 1432166400000L;
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        c.setTimeInMillis(esriFieldTypeDateVal);
        Date expected = c.getTime();
        Date actual = (Date)converter.convert((Object)esriFieldTypeDateVal, Date.class);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

