/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.FeatureCollectionWrapperTestSupport;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilteringSimpleFeatureCollectionTest
extends FeatureCollectionWrapperTestSupport {
    FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    FeatureVisitor lastVisitor = null;
    private ListFeatureCollection visitorCollection;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        SimpleFeatureType schema = DataUtilities.createType((String)"BasicPolygons", (String)"the_geom:MultiPolygon:srid=4326,ID:String,value:int");
        this.visitorCollection = new ListFeatureCollection(schema){

            public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
                FilteringSimpleFeatureCollectionTest.this.lastVisitor = visitor;
            }

            public SimpleFeatureCollection subCollection(Filter filter) {
                if (filter == Filter.INCLUDE) {
                    return this;
                }
                return super.subCollection(filter);
            }
        };
    }

    @Test
    public void testNext() {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        Assert.assertNotNull((Object)collection.features().next());
    }

    @Test
    public void testCount() {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        Assert.assertEquals((long)1L, (long)collection.size());
    }

    @Test
    public void testVisitor() throws IOException {
        PropertyIsEqualTo filter = this.ff.equal((Expression)this.ff.property("someAtt"), (Expression)this.ff.literal((Object)"1"), false);
        FilteringSimpleFeatureCollection collection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.delegate, (Filter)filter);
        collection.accepts(feature -> Assert.assertEquals((Object)1, (Object)feature.getProperty("someAtt").getValue()), null);
    }

    @Test
    public void testMaxVisitorDelegation() throws SchemaException, IOException {
        MaxVisitor visitor = new MaxVisitor((Expression)CommonFactoryFinder.getFilterFactory().property("value"));
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    @Test
    public void testCountVisitorDelegation() throws SchemaException, IOException {
        CountVisitor visitor = new CountVisitor();
        this.assertOptimalVisit((FeatureVisitor)visitor);
    }

    private void assertOptimalVisit(FeatureVisitor visitor) throws IOException {
        FilteringSimpleFeatureCollection retypedCollection = new FilteringSimpleFeatureCollection((SimpleFeatureCollection)this.visitorCollection, (Filter)Filter.INCLUDE);
        retypedCollection.accepts(visitor, null);
        Assert.assertSame((Object)this.lastVisitor, (Object)visitor);
    }
}

