/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.ows;

import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.geotools.data.ows.MockURLChecker;
import org.geotools.data.ows.URLChecker;
import org.geotools.data.ows.URLCheckerException;
import org.geotools.data.ows.URLCheckers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class URLCheckersTest {
    @After
    public void tearDown() throws Exception {
        URLCheckers.reset();
    }

    @Test
    public void testEmptyChecker() {
        MatcherAssert.assertThat((Object)URLCheckers.getEnabledURLCheckers(), (Matcher)Matchers.empty());
        URLCheckers.confirm((String)"myFakeLocation");
        URLCheckers.confirm((String)"http://www.geoserver.org");
        URLCheckers.confirm((String)"ftp://www.sf.net");
    }

    @Test
    public void testDisabledChecker() {
        URLCheckers.register((URLChecker)new MockURLChecker("disabled", false, s -> false));
        MatcherAssert.assertThat((Object)URLCheckers.getEnabledURLCheckers(), (Matcher)Matchers.empty());
    }

    @Test
    public void testReset() {
        MatcherAssert.assertThat((Object)URLCheckers.getEnabledURLCheckers(), (Matcher)Matchers.empty());
        MockURLChecker mockChecker = new MockURLChecker("enabled", true, s -> true);
        URLCheckers.register((URLChecker)mockChecker);
        MatcherAssert.assertThat((Object)URLCheckers.getEnabledURLCheckers(), (Matcher)Matchers.hasItems((Object[])new URLChecker[]{mockChecker}));
        URLCheckers.reset();
        MatcherAssert.assertThat((Object)URLCheckers.getEnabledURLCheckers(), (Matcher)Matchers.empty());
    }

    @Test
    public void testBlockedEscapeSequences() {
        URLCheckers.register((URLChecker)new MockURLChecker(s -> true));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo?%"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo#%"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo/%2e%2e"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo/%2E%2E"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo%2f.."));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///foo%2F.."));
        URLCheckers.confirm((String)"file:///foo?/%2e%2e");
        URLCheckers.confirm((String)"file:///foo?/%2E%2E");
        URLCheckers.confirm((String)"file:///foo?%2f..");
        URLCheckers.confirm((String)"file:///foo?%2F..");
        URLCheckers.confirm((String)"file:///foo#/%2e%2e");
        URLCheckers.confirm((String)"file:///foo#/%2E%2E");
        URLCheckers.confirm((String)"file:///foo#%2f..");
        URLCheckers.confirm((String)"file:///foo#%2F..");
    }

    @Test
    public void testMultipleCheckers() {
        MockURLChecker fileChecker = new MockURLChecker("enabled", true, s -> s.matches("file:///data/.*")){};
        MockURLChecker gtChecker = new MockURLChecker("enabled", true, s -> s.matches("https?://www.geotools.org/.*")){};
        MockURLChecker gsChecker = new MockURLChecker("enabled", true, s -> s.matches("https?://www.geoserver.org/.*")){};
        MockURLChecker apiChecker = new MockURLChecker("enabled", true, s -> s.matches("^https?://localhost:8080/geoserver/ows\\?.*$")){};
        MockURLChecker owsChecker = new MockURLChecker("enabled", true, s -> s.matches("^https?://localhost:8080/geoserver/(\\w+/)?ows((\\?\\!\\\\.\\\\./).)*(\\\\?.*)?$")){};
        URLCheckers.register((URLChecker)fileChecker);
        URLCheckers.register((URLChecker)gtChecker);
        URLCheckers.register((URLChecker)gsChecker);
        URLCheckers.register((URLChecker)apiChecker);
        URLCheckers.register((URLChecker)owsChecker);
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://google.com"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://nyt.com"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///tmp"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://localhost/geoserver/styles/grass_mark.png"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"http://localhost:8080/geoserver/ows/.."));
        URLCheckers.confirm((String)"https://www.geoserver.org/logo.png");
        URLCheckers.confirm((String)"http://www.geotools.org/sld.xsd");
        URLCheckers.confirm((String)"file:///data/dem.tif");
        URLCheckers.confirm((String)"http://localhost:8080/geoserver/ows?");
        URLCheckers.confirm((String)"http://localhost:8080/geoserver/styles/../ows?");
        URLCheckers.confirm((String)"http://localhost:8080/geoserver/ows?SERVICE=WMS&REQUEST=GetCapabilities&VERSION=1.3.0");
        URLCheckers.confirm((String)"https://localhost:8080/geoserver/ne/ows?SERVICE=WFS&REQUEST=GetCapabilities&VERSION=1.1.0");
        URLCheckers.confirm((String)"file:///data/../data/dem.tif");
        URLCheckers.confirm((String)"file:/data/../data/dem.tif");
        URLCheckers.confirm((String)"file:///data/./dem.tif");
        URLCheckers.confirm((String)"file:/data/./dem.tif");
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///tmp"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.confirm((String)"file:///data/../tmp"));
    }

    @Test
    public void testNormalizationError() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b?\\"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b?\""));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b?<"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b?>"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b?|"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b#\\"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b#\""));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b#<"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b#>"));
        Assert.assertThrows(URLCheckerException.class, () -> URLCheckers.normalize((String)"file:///a/../b#|"));
    }

    @Test
    public void testNormalization() {
        Assert.assertEquals((Object)"file:///data/dem.tif", (Object)URLCheckers.normalize((String)"file:///data/../data/dem.tif"));
        Assert.assertEquals((Object)"file:///data/dem.tif", (Object)URLCheckers.normalize((String)"file:/data/dem.tif"));
        Assert.assertEquals((Object)"file:///base/file", (Object)URLCheckers.normalize((String)"file:///base/folder/../file"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/styles/icon.png", (Object)URLCheckers.normalize((String)"http://localhost:8080/geoserver/styles/icon.png"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/www/icon.png", (Object)URLCheckers.normalize((String)"http://localhost:8080/geoserver/styles/../www/icon.png"));
        Assert.assertEquals((Object)"http://localhost:8080/geoserver/styles/icon.png", (Object)URLCheckers.normalize((String)"http://localhost:8080/geoserver/styles/./icon.png"));
        Assert.assertEquals((Object)String.join((CharSequence)File.separator, "", "base", "folder", "file"), (Object)URLCheckers.normalize((String)"/base/folder/./file"));
        Assert.assertEquals((Object)String.join((CharSequence)File.separator, "", "file"), (Object)URLCheckers.normalize((String)"/base/folder/../../file"));
        Assert.assertEquals((Object)"file", (Object)URLCheckers.normalize((String)"folder/../file"));
        Assert.assertEquals((Object)String.join((CharSequence)File.separator, "..", "file"), (Object)URLCheckers.normalize((String)"folder/../../file"));
        Assert.assertEquals((Object)"http://example.net/api?ignore=..", (Object)URLCheckers.normalize((String)"http://example.net/api?ignore=.."));
        Assert.assertEquals((Object)"C:\\directory\\file", (Object)URLCheckers.normalize((String)"C:\\directory\\file"));
    }
}

