/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureEvent;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLocking;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureLocking;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.data.DataTestCase;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiLineString;

public class MemoryDataStoreTest
extends DataTestCase {
    MemoryDataStore data;
    SimpleFeatureType riverType;
    SimpleFeature[] riverFeatures;
    ReferencedEnvelope riverBounds;
    Transaction defaultTransaction = new DefaultTransaction();

    public void init() throws Exception {
        super.init();
        this.data = new MemoryDataStore();
        this.data.addFeatures(this.roadFeatures);
        this.riverType = SimpleFeatureTypeBuilder.retype((SimpleFeatureType)((DataTestCase)this).riverType, (CoordinateReferenceSystem)CRS.decode((String)"EPSG:4326"));
        this.riverBounds = new ReferencedEnvelope((Envelope)((DataTestCase)this).riverBounds, CRS.decode((String)"EPSG:4326"));
        this.riverFeatures = new SimpleFeature[((DataTestCase)this).riverFeatures.length];
        for (int i = 0; i < this.riverFeatures.length; ++i) {
            this.riverFeatures[i] = SimpleFeatureBuilder.retype((SimpleFeature)((DataTestCase)this).riverFeatures[i], (SimpleFeatureType)this.riverType);
        }
        this.data.addFeatures(this.riverFeatures);
    }

    @After
    public void tearDown() throws Exception {
        this.defaultTransaction.close();
        this.data = null;
        super.tearDown();
    }

    @Test
    public void testEmpty() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"namespace.typename", (String)"name:String,id:0,geom:MultiLineString");
        MemoryDataStore memory = new MemoryDataStore(type);
        ContentFeatureSource source = memory.getFeatureSource("typename");
        Assert.assertEquals((long)0L, (long)source.getCount(Query.ALL));
    }

    @Test
    public void testFixture() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"namespace.typename", (String)"name:String,id:0,geom:MultiLineString");
        Assert.assertEquals((String)"namespace", (Object)"namespace", (Object)type.getName().getNamespaceURI());
        Assert.assertEquals((String)"typename", (Object)"typename", (Object)type.getTypeName());
        Assert.assertEquals((String)"attributes", (long)3L, (long)type.getAttributeCount());
        Assert.assertEquals((String)"a1", (Object)"name", (Object)type.getDescriptor(0).getLocalName());
        Assert.assertEquals((String)"a1", String.class, (Object)type.getDescriptor(0).getType().getBinding());
        Assert.assertEquals((String)"a2", (Object)"id", (Object)type.getDescriptor(1).getLocalName());
        Assert.assertEquals((String)"a2", Integer.class, (Object)type.getDescriptor(1).getType().getBinding());
        Assert.assertEquals((String)"a3", (Object)"geom", (Object)type.getDescriptor(2).getLocalName());
        Assert.assertEquals((String)"a3", MultiLineString.class, (Object)type.getDescriptor(2).getType().getBinding());
    }

    @Test
    public void testMemoryDataStore() throws Exception {
        MemoryDataStore store = new MemoryDataStore();
        Assert.assertNotNull((Object)store);
        String[] typeNames = store.getTypeNames();
        Assert.assertNotNull((Object)typeNames);
        Assert.assertEquals((long)0L, (long)typeNames.length);
    }

    @Test
    public void testMemoryDataStoreFeatureCollection() throws IOException {
        MemoryDataStore store = new MemoryDataStore(DataUtilities.collection((SimpleFeature[])this.roadFeatures));
        this.assertStoreHasFeatureType((DataStore)store, "road");
    }

    @Test
    public void testMemoryDataStoreAddFeatures() throws Exception {
        MemoryDataStore store = new MemoryDataStore();
        Assert.assertNotNull((Object)store);
        store.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature[])this.roadFeatures));
        this.assertStoreHasFeatureType((DataStore)store, "road");
        ContentFeatureSource featureSource = store.getFeatureSource("road");
        SimpleFeatureCollection features = featureSource.getFeatures();
        int size = features.size();
        Assert.assertEquals((long)this.roadFeatures.length, (long)size);
    }

    @Test
    public void testMemoryDataStoreFeatureArray() throws IOException {
        MemoryDataStore store = new MemoryDataStore(this.roadFeatures);
        this.assertStoreHasFeatureType((DataStore)store, "road");
    }

    @Test
    public void testMemoryDataStoreFeatureReader() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);){
            MemoryDataStore store = new MemoryDataStore(reader);
            this.assertStoreHasFeatureType((DataStore)store, "road");
        }
    }

    private void assertStoreHasFeatureType(DataStore store, String featureType) throws IOException {
        Assert.assertNotNull((Object)store);
        Assert.assertNotNull((Object)featureType);
        SimpleFeatureType schema = store.getSchema(featureType);
        Assert.assertNotNull((Object)schema);
    }

    @Test
    public void testGetFeatureTypes() throws IOException {
        Object[] names = this.data.getTypeNames();
        Assert.assertEquals((long)2L, (long)names.length);
        Assert.assertTrue((boolean)this.contains(names, "road"));
        Assert.assertTrue((boolean)this.contains(names, "river"));
    }

    boolean contains(Object[] array, Object expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (Object o : array) {
            if (!o.equals(expected)) continue;
            return true;
        }
        return false;
    }

    boolean containsLax(SimpleFeature[] array, SimpleFeature expected) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (SimpleFeature simpleFeature : array) {
            if (!this.match(simpleFeature, expected)) continue;
            return true;
        }
        return false;
    }

    boolean match(SimpleFeature expected, SimpleFeature actual) {
        SimpleFeatureType type = expected.getFeatureType();
        for (int i = 0; i < type.getAttributeCount(); ++i) {
            Object av = actual.getAttribute(i);
            Object ev = expected.getAttribute(i);
            if (av == null && ev != null) {
                return false;
            }
            if (ev == null && av != null) {
                return false;
            }
            if (av.equals(ev)) continue;
            return false;
        }
        return true;
    }

    @Test
    public void testGetSchema() throws IOException {
        Assert.assertSame((Object)this.roadType, (Object)this.data.getSchema("road"));
        Assert.assertSame((Object)this.riverType, (Object)this.data.getSchema("river"));
    }

    void assertCovers(String msg, SimpleFeatureCollection c1, SimpleFeatureCollection c2) {
        if (c1 == c2) {
            return;
        }
        Assert.assertNotNull((String)msg, (Object)c1);
        Assert.assertNotNull((String)msg, (Object)c2);
        Assert.assertEquals((String)(msg + " size"), (long)c1.size(), (long)c2.size());
        try (SimpleFeatureIterator i = c1.features();){
            while (i.hasNext()) {
                SimpleFeature f = (SimpleFeature)i.next();
                Assert.assertTrue((String)(msg + " " + f.getID()), (boolean)c2.contains((Object)f));
            }
        }
    }

    @Test
    public void testGetFeatureReader() throws IOException {
        try (FeatureReader reader = this.data.getFeatureSource("road").getReader();){
            this.assertCovered(this.roadFeatures, (FeatureReader<SimpleFeatureType, SimpleFeature>)reader);
            Assert.assertFalse((boolean)reader.hasNext());
        }
    }

    @Test
    public void testGetFeatureReaderMutability() throws IOException {
        SimpleFeature feature;
        try (FeatureReader reader = this.data.getFeatureSource("road").getReader();){
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                feature.setAttribute("name", null);
            }
        }
        reader = this.data.getFeatureSource("road").getReader();
        while (reader.hasNext()) {
            feature = (SimpleFeature)reader.next();
            Assert.assertNotNull((Object)feature.getAttribute("name"));
        }
        reader.close();
        try {
            reader.next();
            Assert.fail((String)"next should fail with an IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testGetFeatureReaderConcurancy() throws NoSuchElementException, IOException {
        try (FeatureReader reader1 = this.data.getFeatureSource("road").getReader();
             FeatureReader reader2 = this.data.getFeatureSource("road").getReader();
             FeatureReader reader3 = this.data.getFeatureSource("river").getReader();){
            while (reader1.hasNext() || reader2.hasNext() || reader3.hasNext()) {
                Assert.assertTrue((boolean)this.contains(this.roadFeatures, reader1.next()));
                Assert.assertTrue((boolean)this.contains(this.roadFeatures, reader2.next()));
                if (!reader3.hasNext()) continue;
                Assert.assertTrue((boolean)this.contains(this.riverFeatures, reader3.next()));
            }
            try {
                reader1.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader2.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                reader3.next();
                Assert.fail((String)"next should fail with an IOException");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterAutoCommit() throws NoSuchElementException, IOException {
        SimpleFeatureType type = this.data.getSchema("road");
        try (FeatureReader reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);){
            Assert.assertFalse((boolean)(reader instanceof FilteringFeatureReader));
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(reader));
        }
        reader = this.data.getFeatureReader(new Query("road", (Filter)Filter.EXCLUDE), Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)0L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), Transaction.AUTO_COMMIT);
        try {
            Assert.assertTrue((boolean)(reader instanceof FilteringFeatureReader));
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)1L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testGetFeatureReaderFilterTransaction() throws NoSuchElementException, IOException {
        SimpleFeatureType type = this.data.getSchema("road");
        try (FeatureReader reader = this.data.getFeatureReader(new Query("road", (Filter)Filter.EXCLUDE), this.defaultTransaction);){
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)0L, (long)this.count(reader));
        }
        reader = this.data.getFeatureReader(new Query("road"), this.defaultTransaction);
        try {
            Assert.assertTrue((boolean)(reader instanceof DiffFeatureReader));
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), this.defaultTransaction);
        try {
            Assert.assertEquals((Object)type, (Object)reader.getFeatureType());
            Assert.assertEquals((long)1L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try (FeatureWriter writer = ((ContentFeatureStore)this.data.getFeatureSource("road", this.defaultTransaction)).getWriter((Filter)Filter.INCLUDE);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals("road.rd1")) continue;
                writer.remove();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", (Filter)Filter.EXCLUDE), this.defaultTransaction);
        try {
            Assert.assertEquals((long)0L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road"), this.defaultTransaction);
        try {
            Assert.assertEquals((long)(this.roadFeatures.length - 1), (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), this.defaultTransaction);
        try {
            Assert.assertEquals((long)0L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.defaultTransaction.rollback();
        reader = this.data.getFeatureReader(new Query("road", (Filter)Filter.EXCLUDE), this.defaultTransaction);
        try {
            Assert.assertEquals((long)0L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road"), this.defaultTransaction);
        try {
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), this.defaultTransaction);
        try {
            Assert.assertEquals((long)1L, (long)this.count(reader));
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testOrderPreservationRoad() throws Exception {
        this.assertOrderSame(this.roadFeatures);
    }

    @Test
    public void testOrderPreservationRiver() throws Exception {
        this.assertOrderSame(this.riverFeatures);
    }

    @Test
    public void testOrderPreservationMemFetures() throws Exception {
        SimpleFeature[] dynFeatures = new SimpleFeature[]{SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{1, this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "r1"}, null), SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{2, this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "r2"}, null), SimpleFeatureBuilder.build((SimpleFeatureType)this.roadType, (Object[])new Object[]{3, this.line(new int[]{3, 2, 4, 2, 5, 3}), "r3"}, null)};
        this.assertOrderSame(dynFeatures);
    }

    void assertOrderSame(SimpleFeature ... features) throws Exception {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])features);){
            MemoryDataStore store1 = new MemoryDataStore(reader);
            this.assertReaderOrderSame(features, (DataStore)store1);
        }
        MemoryDataStore store2 = new MemoryDataStore(features);
        this.assertReaderOrderSame(features, (DataStore)store2);
    }

    private void assertReaderOrderSame(SimpleFeature[] features, DataStore store) throws IOException {
        try (FeatureReader r1 = store.getFeatureReader(new Query(features[0].getFeatureType().getTypeName()), Transaction.AUTO_COMMIT);
             FeatureReader r2 = DataUtilities.reader((SimpleFeature[])features);){
            while (r1.hasNext() && r2.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)r1.next();
                SimpleFeature f2 = (SimpleFeature)r2.next();
                Assert.assertEquals((Object)f1, (Object)f2);
            }
            Assert.assertEquals((Object)r1.hasNext(), (Object)r2.hasNext());
        }
    }

    void assertCovered(SimpleFeature[] features, FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws NoSuchElementException, IOException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                Assert.assertTrue((boolean)this.contains(features, reader.next()));
                ++count;
            }
        }
        Assert.assertEquals((long)features.length, (long)count);
    }

    boolean covers(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature ... array) throws NoSuchElementException, IOException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    boolean covers(SimpleFeatureIterator reader, SimpleFeature ... array) throws NoSuchElementException, IOException {
        int count = 0;
        try (SimpleFeatureIterator simpleFeatureIterator = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.contains(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    boolean coversLax(FeatureReader<SimpleFeatureType, SimpleFeature> reader, SimpleFeature ... array) throws NoSuchElementException, IOException {
        int count = 0;
        try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    boolean coversLax(SimpleFeatureIterator reader, SimpleFeature ... array) throws NoSuchElementException, IOException {
        int count = 0;
        try (SimpleFeatureIterator simpleFeatureIterator = reader;){
            while (reader.hasNext()) {
                SimpleFeature feature = (SimpleFeature)reader.next();
                if (!this.containsLax(array, feature)) {
                    boolean bl = false;
                    return bl;
                }
                ++count;
            }
        }
        return count == array.length;
    }

    @Test(expected=IOException.class)
    public void testGetFeatureWriter() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(writer));
            Assert.assertFalse((boolean)writer.hasNext());
            writer.next();
            Assert.fail((String)"Should not be able to use a closed writer");
        }
    }

    @Test
    public void testGetFeatureWriterRemove() throws IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);){
            while (writer.hasNext()) {
                SimpleFeature feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals("road.rd1")) continue;
                writer.remove();
            }
            Assert.assertEquals((long)(this.roadFeatures.length - 1), (long)this.data.entry("road").getMemory().size());
        }
    }

    @Test
    public void testGetFeaturesWriterAdd() throws IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);){
            SimpleFeature feature;
            while (writer.hasNext()) {
                feature = (SimpleFeature)writer.next();
            }
            Assert.assertFalse((boolean)writer.hasNext());
            feature = (SimpleFeature)writer.next();
            feature.setAttributes(this.newRoad.getAttributes());
            writer.write();
            Assert.assertFalse((boolean)writer.hasNext());
            Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)this.data.entry("road").getMemory().size());
        }
    }

    @Test
    public void testGetFeaturesWriterModify() throws IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);){
            SimpleFeature feature;
            while (writer.hasNext()) {
                feature = (SimpleFeature)writer.next();
                if (!feature.getID().equals("road.rd1")) continue;
                feature.setAttribute("name", (Object)"changed");
                writer.write();
            }
            feature = (SimpleFeature)this.data.entry("road").getMemory().get("road.rd1");
            Assert.assertEquals((Object)"changed", (Object)feature.getAttribute("name"));
        }
    }

    @Test
    public void testGetFeatureWriterTypeNameTransaction() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(writer));
        }
    }

    @Test
    public void testGetFeatureWriterAppendTypeNameTransaction() throws Exception {
        try (FeatureWriter writer = this.data.getFeatureWriterAppend("road", Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)0L, (long)this.count(writer));
        }
    }

    @Test
    public void testGetFeatureWriterFilter() throws NoSuchElementException, IOException {
        try (FeatureWriter writer = this.data.getFeatureWriter("road", (Filter)Filter.EXCLUDE, Transaction.AUTO_COMMIT);){
            Assert.assertEquals((long)0L, (long)this.count(writer));
        }
        writer = this.data.getFeatureWriter("road", (Filter)Filter.INCLUDE, Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((long)this.roadFeatures.length, (long)this.count(writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
        writer = this.data.getFeatureWriter("road", this.rd1Filter, Transaction.AUTO_COMMIT);
        try {
            Assert.assertEquals((long)1L, (long)this.count(writer));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Test
    public void testGetFeatureWriterTransaction() throws Exception {
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();
             FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, (Transaction)t1);
             FeatureWriter writer2 = this.data.getFeatureWriterAppend("road", (Transaction)t2);){
            SimpleFeature feature;
            int i;
            SimpleFeature[] ORIGIONAL = this.roadFeatures;
            SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
            SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
            SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
            int index = 0;
            for (i = 0; i < ORIGIONAL.length; ++i) {
                feature = ORIGIONAL[i];
                if (feature.getID().equals("road.rd1")) continue;
                REMOVE[index++] = feature;
            }
            for (i = 0; i < ORIGIONAL.length; ++i) {
                ADD[i] = ORIGIONAL[i];
            }
            ADD[i] = this.newRoad;
            for (i = 0; i < REMOVE.length; ++i) {
                FINAL[i] = REMOVE[i];
            }
            FINAL[i] = this.newRoad;
            try (FeatureReader reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);){
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
            }
            while (writer1.hasNext()) {
                feature = (SimpleFeature)writer1.next();
                Assert.assertEquals((Object)"road.rd1", (Object)feature.getID());
                writer1.remove();
            }
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            writer1.close();
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            feature = (SimpleFeature)writer2.next();
            feature.setAttributes(this.newRoad.getAttributes());
            writer2.write();
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            writer2.close();
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ORIGIONAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, ADD));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t1.commit();
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.covers((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, REMOVE));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            t2.commit();
            reader = this.data.getFeatureReader(new Query("road"), Transaction.AUTO_COMMIT);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t1);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            reader = this.data.getFeatureReader(new Query("road"), (Transaction)t2);
            try {
                Assert.assertTrue((boolean)this.coversLax((FeatureReader<SimpleFeatureType, SimpleFeature>)reader, FINAL));
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testModifyInTransactionFidFilter() throws Exception {
        Geometry geom1;
        SimpleFeature feature;
        Geometry geom12;
        GeometryFactory fac = new GeometryFactory();
        try (FeatureWriter writer1 = this.data.getFeatureWriter("road", this.rd1Filter, this.defaultTransaction);){
            ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 1.0)}));
            writer1.write();
        }
        try (FeatureReader reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), this.defaultTransaction);){
            geom12 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
            Assert.assertEquals((Object)new Coordinate(0.0, 0.0), (Object)geom12.getCoordinates()[0]);
            Assert.assertEquals((Object)new Coordinate(0.0, 1.0), (Object)geom12.getCoordinates()[1]);
        }
        writer1 = this.data.getFeatureWriter("road", this.rd1Filter, this.defaultTransaction);
        try {
            ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(10.0, 0.0), new Coordinate(10.0, 1.0)}));
            writer1.write();
        }
        finally {
            if (writer1 != null) {
                writer1.close();
            }
        }
        reader = this.data.getFeatureReader(new Query("road", this.rd1Filter), this.defaultTransaction);
        try {
            geom12 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
            Assert.assertEquals((Object)new Coordinate(10.0, 0.0), (Object)geom12.getCoordinates()[0]);
            Assert.assertEquals((Object)new Coordinate(10.0, 1.0), (Object)geom12.getCoordinates()[1]);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        try (FeatureWriter writer = this.data.getFeatureWriterAppend("road", this.defaultTransaction);){
            feature = (SimpleFeature)writer.next();
            feature.setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(20.0, 0.0), new Coordinate(20.0, 1.0)}));
            writer.write();
        }
        FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);
        Id filter = filterFactory.id(Collections.singleton(filterFactory.featureId(feature.getID())));
        try (FeatureReader reader = this.data.getFeatureReader(new Query("road", (Filter)filter), this.defaultTransaction);){
            geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
            reader.close();
            Assert.assertEquals((Object)new Coordinate(20.0, 0.0), (Object)geom1.getCoordinates()[0]);
            Assert.assertEquals((Object)new Coordinate(20.0, 1.0), (Object)geom1.getCoordinates()[1]);
        }
        try (FeatureWriter writer1 = this.data.getFeatureWriter("road", (Filter)filter, this.defaultTransaction);){
            ((SimpleFeature)writer1.next()).setDefaultGeometry((Object)fac.createLineString(new Coordinate[]{new Coordinate(30.0, 0.0), new Coordinate(30.0, 1.0)}));
            writer1.write();
        }
        reader = this.data.getFeatureReader(new Query("road", (Filter)filter), this.defaultTransaction);
        try {
            geom1 = (Geometry)((SimpleFeature)reader.next()).getDefaultGeometry();
            Assert.assertEquals((Object)new Coordinate(30.0, 0.0), (Object)geom1.getCoordinates()[0]);
            Assert.assertEquals((Object)new Coordinate(30.0, 1.0), (Object)geom1.getCoordinates()[1]);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Test
    public void testGetFeatureSourceRoad() throws IOException {
        ContentFeatureSource road = this.data.getFeatureSource("road");
        Assert.assertSame((Object)this.roadType, (Object)road.getSchema());
        Assert.assertSame((Object)this.data, (Object)road.getDataStore());
        Assert.assertEquals((long)3L, (long)road.getCount(Query.ALL));
        Assert.assertEquals((Object)new ReferencedEnvelope(1.0, 5.0, 0.0, 4.0, null), (Object)road.getBounds(Query.ALL));
        SimpleFeatureCollection all = road.getFeatures();
        Assert.assertEquals((long)3L, (long)all.size());
        Assert.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.roadFeatures);
        this.assertCovers("all", expected, all);
        Assert.assertEquals((Object)this.roadBounds, (Object)all.getBounds());
        SimpleFeatureCollection some = road.getFeatures(this.rd12Filter);
        Assert.assertEquals((long)2L, (long)some.size());
        Assert.assertEquals((Object)this.rd12Bounds, (Object)some.getBounds());
        Assert.assertEquals((Object)some.getSchema(), (Object)road.getSchema());
        Query query = new Query("road", this.rd12Filter, new String[]{"name", "geom"});
        SimpleFeatureCollection half = road.getFeatures(query);
        Assert.assertEquals((long)2L, (long)half.size());
        Assert.assertEquals((long)2L, (long)((SimpleFeatureType)half.getSchema()).getAttributeCount());
        try (SimpleFeatureIterator reader = half.features();){
            SimpleFeatureType type = ((SimpleFeature)reader.next()).getType();
            SimpleFeatureType actual = (SimpleFeatureType)half.getSchema();
            Assert.assertEquals((Object)type.getTypeName(), (Object)actual.getTypeName());
            Assert.assertEquals((Object)type.getName(), (Object)actual.getName());
            Assert.assertEquals((long)type.getAttributeCount(), (long)actual.getAttributeCount());
            for (int i = 0; i < type.getAttributeCount(); ++i) {
                Assert.assertEquals((Object)type.getDescriptor(i), (Object)actual.getDescriptor(i));
            }
            Assert.assertEquals((Object)type.getGeometryDescriptor(), (Object)actual.getGeometryDescriptor());
            Assert.assertEquals((Object)type, (Object)actual);
            ReferencedEnvelope b = half.getBounds();
            Assert.assertEquals((Object)new Envelope(1.0, 5.0, 0.0, 4.0), (Object)b);
        }
    }

    @Test
    public void testGetFeatureSourceRiver() throws NoSuchElementException, IOException {
        ContentFeatureSource river = this.data.getFeatureSource("river");
        Assert.assertSame((Object)this.riverType, (Object)river.getSchema());
        Assert.assertSame((Object)this.data, (Object)river.getDataStore());
        SimpleFeatureCollection all = river.getFeatures();
        Assert.assertEquals((long)2L, (long)all.size());
        Assert.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
        Assert.assertTrue((String)"rivers", (boolean)this.covers(all.features(), this.riverFeatures));
        SimpleFeatureCollection expected = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.assertCovers("all", expected, all);
        Assert.assertEquals((Object)this.riverBounds, (Object)all.getBounds());
    }

    private void testTransformedFeatures(SimpleFeatureCollection sourceFeatures, SimpleFeatureCollection transformedFeatures, CoordinateReferenceSystem nativeCRS, CoordinateReferenceSystem forcedCRS, CoordinateReferenceSystem reprojectCRS) throws TransformException, FactoryException {
        CoordinateReferenceSystem targetCRS = nativeCRS;
        GeometryCoordinateSequenceTransformer transformer = new GeometryCoordinateSequenceTransformer();
        if (reprojectCRS != null) {
            targetCRS = reprojectCRS;
            if (forcedCRS == null) {
                transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)nativeCRS, (CoordinateReferenceSystem)reprojectCRS, (boolean)true));
            } else {
                transformer.setMathTransform(CRS.findMathTransform((CoordinateReferenceSystem)forcedCRS, (CoordinateReferenceSystem)reprojectCRS, (boolean)true));
            }
        } else if (forcedCRS != null) {
            targetCRS = forcedCRS;
        }
        try (SimpleFeatureIterator i = sourceFeatures.features();
             SimpleFeatureIterator j = transformedFeatures.features();){
            while (i.hasNext() && j.hasNext()) {
                SimpleFeature sourceFeature = (SimpleFeature)i.next();
                SimpleFeature transformedFeature = (SimpleFeature)j.next();
                Assert.assertEquals((Object)targetCRS, (Object)transformedFeature.getFeatureType().getCoordinateReferenceSystem());
                for (int k = 0; k < sourceFeature.getAttributes().size(); ++k) {
                    Object o = sourceFeature.getAttributes().get(k);
                    if (!(o instanceof Geometry)) continue;
                    Geometry sourceGeometry = (Geometry)o;
                    Geometry transformedGeometry = (Geometry)transformedFeature.getAttributes().get(k);
                    Geometry expectedGeometry = sourceGeometry.copy();
                    if (reprojectCRS != null) {
                        expectedGeometry = transformer.transform(expectedGeometry);
                    }
                    Assert.assertEquals((Object)expectedGeometry, (Object)transformedGeometry);
                }
            }
        }
    }

    @Test
    public void testSetsEnvelopeCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        query.setCoordinateSystem((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        ContentFeatureSource river = this.data.getFeatureSource("river");
        SimpleFeatureCollection features = river.getFeatures(query);
        SimpleFeatureCollection expectedFeatures = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.testTransformedFeatures(expectedFeatures, features, sourceCRS, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D, null);
    }

    @Test
    public void testReprojectFeaturesCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        CoordinateReferenceSystem targetCRS = CRS.decode((String)"EPSG:3005");
        query.setCoordinateSystemReproject(targetCRS);
        ContentFeatureSource river = this.data.getFeatureSource("river");
        SimpleFeatureCollection features = river.getFeatures(query);
        SimpleFeatureCollection expectedFeatures = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.testTransformedFeatures(expectedFeatures, features, sourceCRS, null, targetCRS);
    }

    @Test
    public void testSetReprojectFeaturesCrsFromQuery() throws Exception {
        Query query = new Query(Query.ALL);
        query.setCoordinateSystem((CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D);
        query.setCoordinateSystemReproject((CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        ContentFeatureSource river = this.data.getFeatureSource("river");
        SimpleFeatureCollection features = river.getFeatures(query);
        SimpleFeatureCollection expectedFeatures = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.testTransformedFeatures(expectedFeatures, features, sourceCRS, (CoordinateReferenceSystem)DefaultEngineeringCRS.GENERIC_2D, (CoordinateReferenceSystem)DefaultEngineeringCRS.CARTESIAN_2D);
    }

    @Test
    public void testSetsFeaturesCrsFromFeatureType() throws Exception {
        Query query = new Query(Query.ALL);
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)"EPSG:4326");
        ContentFeatureSource river = this.data.getFeatureSource("river");
        SimpleFeatureCollection features = river.getFeatures(query);
        SimpleFeatureCollection expectedFeatures = DataUtilities.collection((SimpleFeature[])this.riverFeatures);
        this.testTransformedFeatures(expectedFeatures, features, sourceCRS, null, null);
    }

    @Test
    public void testGetFeatureStoreModifyFeatures1() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        AttributeDescriptor descriptor = this.roadType.getDescriptor("name");
        road.modifyFeatures(descriptor.getName(), (Object)"changed", this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        Assert.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("name"));
    }

    @Test
    public void testGetFeatureStoreModifyFeatures2() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        AttributeDescriptor descriptor = this.roadType.getDescriptor("name");
        road.modifyFeatures(new Name[]{descriptor.getName()}, new Object[]{"changed"}, this.rd1Filter);
        SimpleFeatureCollection results = road.getFeatures(this.rd1Filter);
        Assert.assertEquals((Object)"changed", (Object)((SimpleFeature)results.features().next()).getAttribute("name"));
    }

    @Test
    public void testGetFeatureStoreRemoveFeatures() throws IOException {
        SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
        road.removeFeatures(this.rd1Filter);
        Assert.assertEquals((long)0L, (long)road.getFeatures(this.rd1Filter).size());
        Assert.assertEquals((long)(this.roadFeatures.length - 1), (long)road.getFeatures().size());
    }

    @Test
    public void testGetFeatureStoreAddFeatures() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});){
            SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
            road.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)reader));
            Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)road.getFeatures().size());
        }
    }

    @Test
    public void testGetFeatureStoreSetFeatures() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});){
            SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
            road.setFeatures(reader);
            Assert.assertEquals((long)1L, (long)road.getFeatures().size());
        }
    }

    @Test
    public void testGetFeatureStoreTransactionSupport() throws Exception {
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            int i;
            SimpleFeatureStore road = (SimpleFeatureStore)this.data.getFeatureSource("road");
            SimpleFeatureStore road1 = (SimpleFeatureStore)this.data.getFeatureSource("road");
            SimpleFeatureStore road2 = (SimpleFeatureStore)this.data.getFeatureSource("road");
            road1.setTransaction((Transaction)t1);
            road2.setTransaction((Transaction)t2);
            SimpleFeature[] ORIGIONAL = this.roadFeatures;
            SimpleFeature[] REMOVE = new SimpleFeature[ORIGIONAL.length - 1];
            SimpleFeature[] ADD = new SimpleFeature[ORIGIONAL.length + 1];
            SimpleFeature[] FINAL = new SimpleFeature[ORIGIONAL.length];
            int index = 0;
            for (i = 0; i < ORIGIONAL.length; ++i) {
                SimpleFeature feature = ORIGIONAL[i];
                if (feature.getID().equals("road.rd1")) continue;
                REMOVE[index++] = feature;
            }
            for (i = 0; i < ORIGIONAL.length; ++i) {
                ADD[i] = ORIGIONAL[i];
            }
            ADD[i] = this.newRoad;
            for (i = 0; i < REMOVE.length; ++i) {
                FINAL[i] = REMOVE[i];
            }
            FINAL[i] = this.newRoad;
            Assert.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
            road1.removeFeatures(this.rd1Filter);
            Assert.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
            Assert.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
            try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{this.newRoad});){
                road2.addFeatures((FeatureCollection)DataUtilities.collection((FeatureReader)reader));
            }
            Assert.assertTrue((boolean)this.covers(road.getFeatures().features(), ORIGIONAL));
            Assert.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
            Assert.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), ADD));
            t1.commit();
            Assert.assertTrue((boolean)this.covers(road.getFeatures().features(), REMOVE));
            Assert.assertTrue((boolean)this.covers(road1.getFeatures().features(), REMOVE));
            Assert.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
            t2.commit();
            Assert.assertTrue((boolean)this.coversLax(road.getFeatures().features(), FINAL));
            Assert.assertTrue((boolean)this.coversLax(road1.getFeatures().features(), FINAL));
            Assert.assertTrue((boolean)this.coversLax(road2.getFeatures().features(), FINAL));
        }
    }

    boolean isLocked(String typeName, String fid) {
        InProcessLockingManager lockingManager = (InProcessLockingManager)this.data.getLockingManager();
        return lockingManager.isLocked(typeName, fid);
    }

    @Test
    public void testFeatureEvents() throws Exception {
        SimpleFeatureStore store1 = (SimpleFeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        SimpleFeatureStore store2 = (SimpleFeatureStore)this.data.getFeatureSource(this.roadFeatures[0].getFeatureType().getTypeName());
        store1.setTransaction(this.defaultTransaction);
        class Listener
        implements FeatureListener {
            String name;
            List<FeatureEvent> events = new ArrayList<FeatureEvent>();

            public Listener(String name) {
                this.name = name;
            }

            public void changed(FeatureEvent featureEvent) {
                this.events.add(featureEvent);
            }

            FeatureEvent getEvent(int i) {
                return this.events.get(i);
            }

            public String toString() {
                return "Feature Listener " + this.name;
            }
        }
        Listener listener1 = new Listener("one");
        Listener listener2 = new Listener("two");
        store1.addFeatureListener((FeatureListener)listener1);
        store2.addFeatureListener((FeatureListener)listener2);
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeature feature = this.roadFeatures[0];
        store1.removeFeatures((Filter)factory.id(Collections.singleton(factory.featureId(feature.getID()))));
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        FeatureEvent event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.REMOVED, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().commit();
        Assert.assertEquals((long)0L, (long)listener1.events.size());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
        event = listener2.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.COMMIT, (Object)event.getType());
        listener1.events.clear();
        listener2.events.clear();
        store1.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ADDED, (Object)event.getType());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store1.getTransaction().rollback();
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ROLLBACK, (Object)event.getType());
        Assert.assertEquals((long)0L, (long)listener2.events.size());
        listener1.events.clear();
        listener2.events.clear();
        store2.addFeatures((FeatureCollection)DataUtilities.collection((SimpleFeature)feature));
        Assert.assertEquals((long)1L, (long)listener1.events.size());
        event = listener1.getEvent(0);
        Assert.assertEquals((Object)feature.getBounds(), (Object)event.getBounds());
        Assert.assertEquals((Object)FeatureEvent.Type.ADDED, (Object)event.getType());
        Assert.assertEquals((long)1L, (long)listener2.events.size());
    }

    @Test
    public void testLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600L);
        SimpleFeatureLocking road = (SimpleFeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures();
        Assert.assertTrue((boolean)this.isLocked("road", "road.rd1"));
    }

    @Test
    public void testUnLockFeatures() throws IOException {
        FeatureLock lock = new FeatureLock("test", 3600L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        road.lockFeatures();
        try {
            road.unLockFeatures();
            Assert.fail((String)"unlock should fail due on AUTO_COMMIT");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try (DefaultTransaction t = new DefaultTransaction();){
            road.setTransaction((Transaction)t);
            try {
                road.unLockFeatures();
                Assert.fail((String)"unlock should fail due lack of authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t.addAuthorization(lock.getAuthorization());
            road.unLockFeatures();
        }
    }

    @Test
    public void testLockFeatureInteraction() throws IOException {
        FeatureLock lockA = new FeatureLock("LockA", 3600L);
        FeatureLock lockB = new FeatureLock("LockB", 3600L);
        try (DefaultTransaction t1 = new DefaultTransaction();
             DefaultTransaction t2 = new DefaultTransaction();){
            FeatureLocking road1 = (FeatureLocking)this.data.getFeatureSource("road");
            FeatureLocking road2 = (FeatureLocking)this.data.getFeatureSource("road");
            road1.setTransaction((Transaction)t1);
            road2.setTransaction((Transaction)t2);
            road1.setFeatureLock(lockA);
            road2.setFeatureLock(lockB);
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd2"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd3"));
            road1.lockFeatures(this.rd1Filter);
            Assert.assertTrue((boolean)this.isLocked("road", "road.rd1"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd2"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd3"));
            road2.lockFeatures(this.rd2Filter);
            Assert.assertTrue((boolean)this.isLocked("road", "road.rd1"));
            Assert.assertTrue((boolean)this.isLocked("road", "road.rd2"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd3"));
            try {
                road1.unLockFeatures(this.rd1Filter);
                Assert.fail((String)"need authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            t1.addAuthorization(lockA.getAuthorization());
            try {
                road1.unLockFeatures(this.rd2Filter);
                Assert.fail((String)"need correct authorization");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            road1.unLockFeatures(this.rd1Filter);
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
            Assert.assertTrue((boolean)this.isLocked("road", "road.rd2"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd3"));
            t2.addAuthorization(lockB.getAuthorization());
            road2.unLockFeatures(this.rd2Filter);
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd2"));
            Assert.assertFalse((boolean)this.isLocked("road", "road.rd3"));
        }
    }

    @Test
    public void testGetFeatureLockingExpire() throws Exception {
        FeatureLock lock = new FeatureLock("Timed", 500L);
        FeatureLocking road = (FeatureLocking)this.data.getFeatureSource("road");
        road.setFeatureLock(lock);
        Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
        road.lockFeatures(this.rd1Filter);
        Assert.assertTrue((boolean)this.isLocked("road", "road.rd1"));
        long then = System.currentTimeMillis();
        do {
            Thread.sleep(15L);
        } while (then > System.currentTimeMillis() - 515L);
        Assert.assertFalse((boolean)this.isLocked("road", "road.rd1"));
    }

    @Test
    public void testRemoveSchema() throws IOException {
        List names = this.data.getNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)2L, (long)names.size());
        this.data.removeSchema("road");
        List namesAfterRemove = this.data.getNames();
        Assert.assertNotNull((Object)namesAfterRemove);
        Assert.assertEquals((long)1L, (long)namesAfterRemove.size());
    }

    @Test
    public void testRemoveTypeThatDoesntExistsGracefulWithoutIOException() throws IOException {
        List names = this.data.getNames();
        Assert.assertNotNull((Object)names);
        Assert.assertEquals((long)2L, (long)names.size());
        try {
            this.data.removeSchema("typeThatDoesntExists");
        }
        catch (IOException e) {
            Assert.fail((String)"remove Schema should act gracfully if it has never been created for that type");
        }
        List namesAfterRemove = this.data.getNames();
        Assert.assertNotNull((Object)namesAfterRemove);
        Assert.assertEquals((long)2L, (long)namesAfterRemove.size());
    }

    @Test
    public void testAddingTwoFeaturesWithSameType() throws IOException {
        MemoryDataStore mds = new MemoryDataStore();
        mds.addFeature(this.roadFeatures[0]);
        mds.addFeature(this.roadFeatures[1]);
        Assert.assertEquals((long)2L, (long)mds.entry("road").getMemory().size());
    }

    @Test
    public void testCallingAddFeaturesWithArrayTwiceAndExtentInitialCollection() throws IOException {
        MemoryDataStore mds = new MemoryDataStore();
        mds.addFeatures(this.roadFeatures);
        SimpleFeature road1 = SimpleFeatureBuilder.template((SimpleFeatureType)this.roadType, null);
        mds.addFeatures(new SimpleFeature[]{road1});
        Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)mds.entry("road").getMemory().size());
    }

    @Test
    public void testCallingAddFeaturesWithCollectionTwiceAndExtentInitialCollection() throws IOException {
        MemoryDataStore mds = new MemoryDataStore();
        mds.addFeatures(Arrays.asList(this.roadFeatures));
        SimpleFeature road1 = SimpleFeatureBuilder.template((SimpleFeatureType)this.roadType, null);
        mds.addFeatures(Collections.singletonList(road1));
        Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)mds.entry("road").getMemory().size());
    }

    @Test
    public void testCallingAddFeaturesWithReaderTwiceAndExtentInitialCollection() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);){
            MemoryDataStore mds = new MemoryDataStore(reader);
            Assert.assertEquals((long)this.roadFeatures.length, (long)mds.entry(this.roadType.getTypeName()).getMemory().size());
            try (FeatureReader secondReader = DataUtilities.reader((SimpleFeature[])new SimpleFeature[]{SimpleFeatureBuilder.template((SimpleFeatureType)this.roadType, null)});){
                mds.addFeatures(secondReader);
                Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)mds.entry("road").getMemory().size());
            }
        }
    }

    @Test
    public void testCallingAddFeaturesWithIteratorTwiceAndExtentInitialCollection() throws IOException {
        try (FeatureReader reader = DataUtilities.reader((SimpleFeature[])this.roadFeatures);){
            MemoryDataStore mds = new MemoryDataStore(reader);
            Assert.assertEquals((long)this.roadFeatures.length, (long)mds.entry(this.roadType.getTypeName()).getMemory().size());
            try (SimpleFeatureIterator featureIterator = DataUtilities.collection((SimpleFeature)SimpleFeatureBuilder.template((SimpleFeatureType)this.roadType, null)).features();){
                mds.addFeatures(featureIterator);
                Assert.assertEquals((long)(this.roadFeatures.length + 1), (long)mds.entry("road").getMemory().size());
            }
        }
    }
}

