/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.api.feature.IllegalAttributeException;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;

public class ForceCoordinateSystemIterator
implements SimpleFeatureIterator,
Iterator<SimpleFeature> {
    protected FeatureIterator<SimpleFeature> reader;
    protected SimpleFeatureBuilder builder;

    ForceCoordinateSystemIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType schema) {
        this.reader = reader;
        this.builder = new SimpleFeatureBuilder(schema);
    }

    public ForceCoordinateSystemIterator(FeatureIterator<SimpleFeature> reader, SimpleFeatureType type, CoordinateReferenceSystem cs) throws SchemaException {
        if (cs == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        CoordinateReferenceSystem originalCs = type.getGeometryDescriptor().getCoordinateReferenceSystem();
        if (!cs.equals(originalCs)) {
            type = FeatureTypes.transform(type, cs);
        }
        this.builder = new SimpleFeatureBuilder(type);
        this.reader = reader;
    }

    public SimpleFeatureType getFeatureType() {
        if (this.reader == null || this.builder == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.builder.getFeatureType();
    }

    @Override
    public SimpleFeature next() throws NoSuchElementException {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        SimpleFeature next = this.reader.next();
        if (this.builder == null) {
            return next;
        }
        try {
            return SimpleFeatureBuilder.retype(next, this.builder);
        }
        catch (IllegalAttributeException eep) {
            throw (IllegalStateException)new IllegalStateException(eep.getMessage()).initCause(eep);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.reader == null) {
            throw new IllegalStateException("Reader has already been closed");
        }
        return this.reader.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
        this.builder = null;
    }
}

