/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.reference;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.temporal.CalendarDate;
import org.geotools.api.temporal.CalendarEra;
import org.geotools.api.temporal.IndeterminateValue;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.JulianDate;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.api.temporal.TemporalReferenceSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultCalendarDate;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultJulianDate;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.temporal.object.DefaultPosition;
import org.geotools.temporal.reference.DefaultCalendarEra;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.geotools.util.SimpleInternationalString;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultCalendarEraTest {
    private CalendarEra calendarEra1;
    private CalendarEra calendarEra2;
    private Calendar cal = Calendar.getInstance();

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "Julian calendar");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "Babylonian calendar");
        DefaultTemporalReferenceSystem frame1 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name1, null);
        DefaultTemporalReferenceSystem frame2 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name2, null);
        int[] calendarDate1 = new int[]{1900, 1, 1};
        int[] calendarDate2 = new int[]{400, 1, 1};
        DefaultCalendarDate referenceDate1 = new DefaultCalendarDate((TemporalReferenceSystem)frame1, IndeterminateValue.BEFORE, (InternationalString)new SimpleInternationalString("Gregorian calendar"), calendarDate1);
        DefaultCalendarDate referenceDate2 = new DefaultCalendarDate((TemporalReferenceSystem)frame2, IndeterminateValue.NOW, (InternationalString)new SimpleInternationalString("Babylonian calendar"), calendarDate2);
        DefaultJulianDate julianReference = new DefaultJulianDate((TemporalReferenceSystem)frame1, IndeterminateValue.NOW, (Number)123456789);
        this.cal.set(1900, 0, 1);
        DefaultInstant begining1 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        this.cal.set(2000, 9, 17);
        DefaultInstant ending1 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        this.cal.set(2000, 1, 1);
        DefaultInstant begining2 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        this.cal.set(2012, 1, 1);
        DefaultInstant ending2 = new DefaultInstant((Position)new DefaultPosition(this.cal.getTime()));
        DefaultPeriod epochOfUse1 = new DefaultPeriod((Instant)begining1, (Instant)ending1);
        DefaultPeriod epochOfUse2 = new DefaultPeriod((Instant)begining2, (Instant)ending2);
        this.calendarEra1 = new DefaultCalendarEra((InternationalString)new SimpleInternationalString("Cenozoic"), (InternationalString)new SimpleInternationalString("no description"), (CalendarDate)referenceDate1, (JulianDate)julianReference, (Period)epochOfUse1);
        this.calendarEra2 = new DefaultCalendarEra((InternationalString)new SimpleInternationalString("Mesozoic"), (InternationalString)new SimpleInternationalString(""), (CalendarDate)referenceDate2, (JulianDate)julianReference, (Period)epochOfUse2);
    }

    @After
    public void tearDown() {
        this.calendarEra1 = null;
        this.calendarEra2 = null;
    }

    @Test
    public void testGetName() {
        InternationalString result = this.calendarEra1.getName();
        Assert.assertNotEquals((Object)this.calendarEra2.getName(), (Object)result);
    }

    @Test
    public void testGetReferenceEvent() {
        InternationalString result = this.calendarEra1.getReferenceEvent();
        Assert.assertNotEquals((Object)this.calendarEra2.getReferenceEvent(), (Object)result);
    }

    @Test
    public void testGetReferenceDate() {
        CalendarDate result = this.calendarEra1.getReferenceDate();
        Assert.assertNotEquals((Object)this.calendarEra2.getReferenceDate(), (Object)result);
    }

    @Test
    public void testGetJulianReference() {
        JulianDate result = this.calendarEra1.getJulianReference();
        Assert.assertEquals((Object)this.calendarEra2.getJulianReference(), (Object)result);
    }

    @Test
    public void testGetEpochOfUse() {
        Period result = this.calendarEra1.getEpochOfUse();
        Assert.assertNotEquals((Object)this.calendarEra2.getEpochOfUse(), (Object)result);
    }

    @Test
    public void testSetName() {
        InternationalString result = this.calendarEra1.getName();
        ((DefaultCalendarEra)this.calendarEra1).setName((InternationalString)new SimpleInternationalString("new Era"));
        Assert.assertNotEquals((Object)this.calendarEra1.getName(), (Object)result);
    }

    @Test
    public void testSetReferenceEvent() {
        InternationalString result = this.calendarEra1.getReferenceEvent();
        ((DefaultCalendarEra)this.calendarEra1).setReferenceEvent((InternationalString)new SimpleInternationalString("new Era description"));
        Assert.assertNotEquals((Object)this.calendarEra1.getReferenceEvent(), (Object)result);
    }

    @Test
    public void testSetReferenceDate() {
        CalendarDate result = this.calendarEra1.getReferenceDate();
        int[] date = new int[]{1950, 6, 10};
        ((DefaultCalendarEra)this.calendarEra1).setReferenceDate((CalendarDate)new DefaultCalendarDate(null, null, null, date));
        Assert.assertNotEquals((Object)this.calendarEra1.getReferenceDate(), (Object)result);
    }

    @Test
    public void testSetJulianReference() {
        JulianDate result = this.calendarEra1.getJulianReference();
        ((DefaultCalendarEra)this.calendarEra1).setJulianReference((JulianDate)new DefaultJulianDate(null, null, (Number)785410));
        Assert.assertNotEquals((Object)this.calendarEra1.getJulianReference(), (Object)result);
    }

    @Test
    public void testSetEpochOfUse() {
        Period result = this.calendarEra1.getEpochOfUse();
        this.cal.set(1900, 10, 10);
        ((DefaultCalendarEra)this.calendarEra1).setEpochOfUse((Period)new DefaultPeriod((Instant)new DefaultInstant((Position)new DefaultPosition(this.cal.getTime())), (Instant)new DefaultInstant((Position)new DefaultPosition(new Date()))));
        Assert.assertNotEquals((Object)this.calendarEra1.getEpochOfUse(), (Object)result);
    }

    @Test
    public void testGetDatingSystem() {
        Collection result = ((DefaultCalendarEra)this.calendarEra1).getDatingSystem();
        Assert.assertEquals((Object)((DefaultCalendarEra)this.calendarEra2).getDatingSystem(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.calendarEra1);
        Assert.assertEquals((Object)this.calendarEra1, (Object)this.calendarEra1);
        Assert.assertNotEquals((Object)this.calendarEra1, (Object)this.calendarEra2);
    }

    @Test
    public void testHashCode() {
        int result = this.calendarEra1.hashCode();
        Assert.assertNotEquals((long)this.calendarEra2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.calendarEra1.toString();
        Assert.assertNotEquals((Object)this.calendarEra2.toString(), (Object)result);
    }
}

