/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.temporal.object;

import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.temporal.IndeterminateValue;
import org.geotools.api.temporal.TemporalPosition;
import org.geotools.api.temporal.TemporalReferenceSystem;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.temporal.object.DefaultTemporalPosition;
import org.geotools.temporal.reference.DefaultTemporalReferenceSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DefaultTemporalPositionTest {
    private TemporalPosition temporalPosition1;
    private TemporalPosition temporalPosition2;

    @Before
    public void setUp() {
        NamedIdentifier name1 = new NamedIdentifier(Citations.CRS, "Gregorian calendar");
        NamedIdentifier name2 = new NamedIdentifier(Citations.CRS, "Julian calendar");
        DefaultTemporalReferenceSystem frame1 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name1, null);
        DefaultTemporalReferenceSystem frame2 = new DefaultTemporalReferenceSystem((ReferenceIdentifier)name2, null);
        this.temporalPosition1 = new DefaultTemporalPosition((TemporalReferenceSystem)frame1, IndeterminateValue.UNKNOWN);
        this.temporalPosition2 = new DefaultTemporalPosition((TemporalReferenceSystem)frame2, IndeterminateValue.NOW);
    }

    @After
    public void tearDown() {
        this.temporalPosition1 = null;
        this.temporalPosition2 = null;
    }

    @Test
    public void testGetIndeterminatePosition() {
        IndeterminateValue result = this.temporalPosition1.getIndeterminatePosition();
        Assert.assertNotEquals((Object)this.temporalPosition2.getIndeterminatePosition(), (Object)result);
    }

    @Test
    public void testGetFrame() {
        TemporalReferenceSystem result = ((DefaultTemporalPosition)this.temporalPosition1).getFrame();
        Assert.assertNotEquals((Object)((DefaultTemporalPosition)this.temporalPosition2).getFrame(), (Object)result);
    }

    @Test
    public void testSetFrame() {
        TemporalReferenceSystem result = ((DefaultTemporalPosition)this.temporalPosition1).getFrame();
        NamedIdentifier name = new NamedIdentifier(Citations.CRS, "Babylonian calendar");
        ((DefaultTemporalPosition)this.temporalPosition1).setFrame((TemporalReferenceSystem)new DefaultTemporalReferenceSystem((ReferenceIdentifier)name, null));
        Assert.assertNotEquals((Object)((DefaultTemporalPosition)this.temporalPosition1).getFrame(), (Object)result);
    }

    @Test
    public void testSetIndeterminatePosition() {
        IndeterminateValue result = this.temporalPosition1.getIndeterminatePosition();
        ((DefaultTemporalPosition)this.temporalPosition1).setIndeterminatePosition(IndeterminateValue.BEFORE);
        Assert.assertNotEquals((Object)this.temporalPosition1.getIndeterminatePosition(), (Object)result);
    }

    @Test
    public void testEquals() {
        Assert.assertNotEquals(null, (Object)this.temporalPosition1);
        Assert.assertEquals((Object)this.temporalPosition1, (Object)this.temporalPosition1);
        Assert.assertNotEquals((Object)this.temporalPosition1, (Object)this.temporalPosition2);
    }

    @Test
    public void testHashCode() {
        int result = this.temporalPosition1.hashCode();
        Assert.assertNotEquals((long)this.temporalPosition2.hashCode(), (long)result);
    }

    @Test
    public void testToString() {
        String result = this.temporalPosition1.toString();
        Assert.assertNotEquals((Object)this.temporalPosition2.toString(), (Object)result);
    }
}

