/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.zoom;

import org.geotools.styling.zoom.WellKnownZoomContextFinder;
import org.geotools.styling.zoom.ZoomContext;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;

public class WellKnownZoomContextFinderTest {
    final double[] WGS84_SCALE_DENOMS = new double[]{5.590822639508929E8, 2.795411320143589E8, 1.3977056600717944E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.1877243575, 2183915.0938621787, 1091957.5469310894, 545978.7734655447, 272989.38673277234, 136494.69336638617, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784, 1066.364791924892, 533.182395962446};

    @Test
    public void testWGS84Scales() throws Exception {
        ZoomContext context = WellKnownZoomContextFinder.getInstance().get("DEFAULT");
        for (int i = 0; i < this.WGS84_SCALE_DENOMS.length; ++i) {
            MatcherAssert.assertThat((Object)context.getScaleDenominator(i), this.mCloseTo(this.WGS84_SCALE_DENOMS[i], 1.0E-8));
        }
    }

    Matcher<Double> mCloseTo(final double value, final double epsilon) {
        return new BaseMatcher<Double>(){

            public boolean matches(Object arg0) {
                return Math.abs(value / (Double)arg0 - 1.0) <= epsilon;
            }

            public void describeTo(Description arg0) {
                arg0.appendText("divided by ").appendValue((Object)value).appendText(" within ").appendValue((Object)epsilon).appendText(" of 1.");
            }
        };
    }
}

