/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.awt.Color;
import java.util.Arrays;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.Mark;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.RasterSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.SemanticType;
import org.geotools.api.style.Stroke;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.NameImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.visitor.RescaleStyleVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import si.uom.SI;

public class RescaleStyleVisitorTest {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory ff;
    RescaleStyleVisitor visitor;
    double scale;

    @Before
    public void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory(null);
        this.sb = new StyleBuilder(this.sf, this.ff);
        this.scale = 2.0;
        this.visitor = new RescaleStyleVisitor(this.scale);
    }

    @Test
    public void testStyleDuplication() throws IllegalFilterException {
        Style oldStyle = this.sb.createStyle("FTSName", (Symbolizer)this.sf.createPolygonSymbolizer());
        ((FeatureTypeStyle)oldStyle.featureTypeStyles().get(0)).semanticTypeIdentifiers().addAll(Arrays.asList(SemanticType.valueOf((String)"simple"), SemanticType.valueOf((String)"generic:geometry")));
        oldStyle.accept((StyleVisitor)this.visitor);
        Style newStyle = (Style)this.visitor.getCopy();
        Assert.assertNotNull((Object)newStyle);
    }

    @Test
    public void testStyle() throws Exception {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        fts.featureTypeNames().add(new NameImpl("feature-type-1"));
        FeatureTypeStyle fts2 = this.fts2();
        Style style = this.sf.getDefaultStyle();
        style.featureTypeStyles().add(fts);
        style.featureTypeStyles().add(fts2);
        style.accept((StyleVisitor)this.visitor);
        Style notEq = this.sf.getDefaultStyle();
        fts2 = this.fts2();
        notEq.featureTypeStyles().add(fts2);
    }

    private FeatureTypeStyle fts2() {
        FeatureTypeStyle fts2 = this.sf.createFeatureTypeStyle();
        Rule rule = this.sf.createRule();
        fts2.rules().add(rule);
        fts2.featureTypeNames().add(new NameImpl("feature-type-2"));
        return fts2;
    }

    @Test
    public void testRule() throws Exception {
        LineSymbolizer symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        PolygonSymbolizer symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        RasterSymbolizer symb3 = this.sf.createRasterSymbolizer();
        Rule rule = this.sf.createRule();
        rule.symbolizers().addAll(Arrays.asList(symb1, symb2, symb3));
        rule.accept((StyleVisitor)this.visitor);
        Rule clone = (Rule)this.visitor.getCopy();
        Assert.assertNotNull((Object)clone);
    }

    @Test
    public void testStroke() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        original.accept((StyleVisitor)this.visitor);
        Stroke clone = (Stroke)this.visitor.getCopy();
        Assert.assertEquals((double)4.0, (double)((Double)clone.getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((double)10.0, (double)clone.getDashArray()[0], (double)0.0);
        Assert.assertEquals((double)20.0, (double)clone.getDashArray()[1], (double)0.0);
    }

    @Test
    public void testDynamicStroke() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0);
        original.setDashArray(Arrays.asList(this.ff.literal((Object)"5 10")));
        original.accept((StyleVisitor)this.visitor);
        Stroke clone = (Stroke)this.visitor.getCopy();
        Assert.assertEquals((double)4.0, (double)Double.valueOf((String)clone.getWidth().evaluate(null)), (double)0.001);
        Assert.assertNotNull((Object)original.dashArray());
        Assert.assertEquals((long)1L, (long)original.dashArray().size());
        Assert.assertEquals((Object)"10.0 20.0", (Object)((Expression)clone.dashArray().get(0)).evaluate(null));
    }

    @Test
    public void testTextSymbolizer() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "label");
        ts.getOptions().put("maxDisplacement", "10");
        ts.getOptions().put("graphic-margin", "10 20");
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"20", clone.getOptions().get("maxDisplacement"));
        Assert.assertEquals((Object)"20 40", clone.getOptions().get("graphic-margin"));
    }

    @Test
    public void testTextSymbolizerArraySingleValue() throws Exception {
        TextSymbolizer ts = this.sb.createTextSymbolizer(Color.BLACK, (Font)null, "label");
        ts.getOptions().put("graphic-margin", "10");
        ts.accept((StyleVisitor)this.visitor);
        TextSymbolizer clone = (TextSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"20", clone.getOptions().get("graphic-margin"));
    }

    @Test
    public void testRescaleGraphicFillStrokes() {
        StyleBuilder sb = new StyleBuilder();
        Stroke stroke = sb.createStroke();
        stroke.setColor(null);
        Graphic graphic = sb.createGraphic(null, sb.createMark("square", null, sb.createStroke(1.0)), null);
        double expectedAnchorPointX = 0.25;
        double expectedAnchorPointY = 0.75;
        graphic.setAnchorPoint(sb.createAnchorPoint(expectedAnchorPointX, expectedAnchorPointY));
        stroke.setGraphicStroke(graphic);
        Fill fill = sb.createFill();
        fill.setColor(null);
        fill.setGraphicFill(sb.createGraphic(null, sb.createMark("square", null, sb.createStroke(2.0)), null));
        PolygonSymbolizer ps = sb.createPolygonSymbolizer(stroke, fill);
        ps.accept((StyleVisitor)this.visitor);
        PolygonSymbolizer rps = (PolygonSymbolizer)this.visitor.getCopy();
        Mark rm = (Mark)rps.getStroke().getGraphicStroke().graphicalSymbols().get(0);
        Assert.assertEquals((double)2.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        rm = (Mark)rps.getFill().getGraphicFill().graphicalSymbols().get(0);
        Assert.assertEquals((double)4.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        AnchorPoint actualAnchorPoint = rps.getStroke().getGraphicStroke().getAnchorPoint();
        Assert.assertNotNull((Object)actualAnchorPoint);
        Assert.assertEquals((double)expectedAnchorPointX, (double)((Double)actualAnchorPoint.getAnchorPointX().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((double)expectedAnchorPointY, (double)((Double)actualAnchorPoint.getAnchorPointY().evaluate(null, Double.class)), (double)0.0);
        LineSymbolizer ls = sb.createLineSymbolizer(stroke);
        ls.accept((StyleVisitor)this.visitor);
        LineSymbolizer lps = (LineSymbolizer)this.visitor.getCopy();
        rm = (Mark)lps.getStroke().getGraphicStroke().graphicalSymbols().get(0);
        Assert.assertEquals((double)2.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
    }

    @Test
    public void testRescaleLocalUOM() throws Exception {
        Stroke original = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        original.setWidth((Expression)this.ff.literal((Object)"2m"));
        original.accept((StyleVisitor)this.visitor);
        Stroke clone = (Stroke)this.visitor.getCopy();
        Assert.assertEquals((Object)"4m", (Object)clone.getWidth().evaluate(null, String.class));
    }

    @Test
    public void testRescaleLocalPixelInMetersSymbolizer() throws Exception {
        Stroke stroke = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        stroke.setWidth((Expression)this.ff.literal((Object)"2px"));
        LineSymbolizer ls = this.sb.createLineSymbolizer(stroke);
        ls.setUnitOfMeasure(SI.METRE);
        ls.accept((StyleVisitor)this.visitor);
        LineSymbolizer clone = (LineSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"4px", (Object)clone.getStroke().getWidth().evaluate(null, String.class));
    }

    @Test
    public void testRescaleLocalPixelInPixelSymbolizer() throws Exception {
        Stroke stroke = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        stroke.setWidth((Expression)this.ff.literal((Object)"2px"));
        LineSymbolizer ls = this.sb.createLineSymbolizer(stroke);
        ls.accept((StyleVisitor)this.visitor);
        LineSymbolizer clone = (LineSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"4", (Object)clone.getStroke().getWidth().evaluate(null, String.class));
    }

    @Test
    public void testRescalePerpendicularOffset() throws Exception {
        Stroke stroke = this.sb.createStroke(Color.RED, 2.0, new float[]{5.0f, 10.0f});
        LineSymbolizer ls = this.sb.createLineSymbolizer(stroke);
        ls.setPerpendicularOffset((Expression)this.ff.literal(2));
        ls.accept((StyleVisitor)this.visitor);
        LineSymbolizer clone = (LineSymbolizer)this.visitor.getCopy();
        Assert.assertEquals((Object)"4", (Object)clone.getPerpendicularOffset().evaluate(null, String.class));
    }

    @Test
    public void testRescalePolygonMargin() throws Exception {
        StyleBuilder sb = new StyleBuilder();
        Fill fill = sb.createFill();
        fill.setColor(null);
        fill.setGraphicFill(sb.createGraphic(null, sb.createMark("square", null, sb.createStroke(2.0)), null));
        PolygonSymbolizer polygonSymbolizer = sb.createPolygonSymbolizer(sb.createStroke(), fill);
        polygonSymbolizer.getOptions().put("graphic-margin", "1 2 3 4");
        polygonSymbolizer.accept((StyleVisitor)this.visitor);
        PolygonSymbolizer rps = (PolygonSymbolizer)this.visitor.getCopy();
        Mark rm = (Mark)rps.getFill().getGraphicFill().graphicalSymbols().get(0);
        Assert.assertEquals((double)4.0, (double)((Double)rm.getStroke().getWidth().evaluate(null, Double.class)), (double)0.0);
        Assert.assertEquals((Object)"2 4 6 8", rps.getOptions().get("graphic-margin"));
    }
}

