/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Arrays;
import java.util.List;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.style.FeatureTypeStyle;
import org.geotools.api.style.LineSymbolizer;
import org.geotools.api.style.PolygonSymbolizer;
import org.geotools.api.style.Rule;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleFactory;
import org.geotools.api.style.Symbolizer;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.visitor.LegendRenderingSelectorStyleVisitor;
import org.geotools.styling.visitor.MapRenderingSelectorStyleVisitor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenderingSelectorStyleVisitorTest {
    StyleBuilder sb;
    StyleFactory sf;
    FilterFactory ff;

    @Before
    public void setUp() throws Exception {
        this.sf = CommonFactoryFinder.getStyleFactory(null);
        this.ff = CommonFactoryFinder.getFilterFactory(null);
        this.sb = new StyleBuilder(this.sf, this.ff);
    }

    @Test
    public void testLegendRenderingSelection() {
        Style noOption = this.buildStyleWithInclusionOption(null);
        LegendRenderingSelectorStyleVisitor selectorStyleVisitor = new LegendRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(noOption);
        Assert.assertEquals((Object)noOption, (Object)selectorStyleVisitor.getCopy());
        Style normal = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.NORMAL.getOption());
        selectorStyleVisitor = new LegendRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(normal);
        Assert.assertEquals((Object)normal, (Object)selectorStyleVisitor.getCopy());
        Style legendOnly = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.LEGENDONLY.getOption());
        selectorStyleVisitor = new LegendRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(legendOnly);
        Assert.assertEquals((Object)legendOnly, (Object)selectorStyleVisitor.getCopy());
        Style mapOnly = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.MAPONLY.getOption());
        selectorStyleVisitor = new LegendRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(mapOnly);
        Style renderingSelected = (Style)selectorStyleVisitor.getCopy();
        Assert.assertNotEquals((Object)mapOnly, (Object)renderingSelected);
        List featureTypeStyles = renderingSelected.featureTypeStyles();
        Assert.assertEquals((long)1L, (long)featureTypeStyles.size());
        List rules = ((FeatureTypeStyle)featureTypeStyles.get(0)).rules();
        Assert.assertEquals((long)1L, (long)rules.size());
        List symbolizers = ((Rule)rules.get(0)).symbolizers();
        Assert.assertEquals((long)symbolizers.size(), (long)1L);
    }

    @Test
    public void testMapRenderingSelection() {
        Style noOption = this.buildStyleWithInclusionOption(null);
        MapRenderingSelectorStyleVisitor selectorStyleVisitor = new MapRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(noOption);
        Assert.assertEquals((Object)noOption, (Object)selectorStyleVisitor.getCopy());
        Style normal = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.NORMAL.getOption());
        selectorStyleVisitor = new MapRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(normal);
        Assert.assertEquals((Object)normal, (Object)selectorStyleVisitor.getCopy());
        Style mapOnly = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.MAPONLY.getOption());
        selectorStyleVisitor = new MapRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(mapOnly);
        Assert.assertEquals((Object)mapOnly, (Object)selectorStyleVisitor.getCopy());
        Style legendOnly = this.buildStyleWithInclusionOption(FeatureTypeStyle.RenderingSelectionOptions.LEGENDONLY.getOption());
        selectorStyleVisitor = new MapRenderingSelectorStyleVisitor();
        selectorStyleVisitor.visit(legendOnly);
        Style renderingSelected = (Style)selectorStyleVisitor.getCopy();
        Assert.assertNotEquals((Object)legendOnly, (Object)renderingSelected);
        List featureTypeStyles = renderingSelected.featureTypeStyles();
        Assert.assertEquals((long)1L, (long)featureTypeStyles.size());
        List rules = ((FeatureTypeStyle)featureTypeStyles.get(0)).rules();
        Assert.assertEquals((long)1L, (long)rules.size());
        List symbolizers = ((Rule)rules.get(0)).symbolizers();
        Assert.assertEquals((long)symbolizers.size(), (long)1L);
    }

    private Style buildStyleWithInclusionOption(String inclusionValue) {
        Style style = this.sb.createStyle("FTSName", (Symbolizer)this.sf.createPolygonSymbolizer());
        if (inclusionValue != null) {
            ((FeatureTypeStyle)style.featureTypeStyles().get(0)).getOptions().put("inclusion", inclusionValue);
        }
        Rule rule = this.sf.createRule();
        LineSymbolizer symb1 = this.sf.createLineSymbolizer(this.sf.getDefaultStroke(), "geometry");
        rule.symbolizers().add(symb1);
        if (inclusionValue != null) {
            rule.getOptions().put("inclusion", inclusionValue);
        }
        Rule rule2 = this.sf.createRule();
        PolygonSymbolizer symb2 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "shape");
        rule2.symbolizers().add(symb2);
        PolygonSymbolizer symb3 = this.sf.createPolygonSymbolizer(this.sf.getDefaultStroke(), this.sf.getDefaultFill(), "extension");
        if (inclusionValue != null) {
            symb3.getOptions().put("inclusion", inclusionValue);
        }
        rule2.symbolizers().add(symb3);
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle(new Rule[]{rule});
        fts.rules().addAll(Arrays.asList(rule, rule2));
        style.featureTypeStyles().add(fts);
        return style;
    }
}

