/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.WKTReader2;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;

public class DecimatorTest {
    GeometryFactory gf = new GeometryFactory();
    LiteCoordinateSequenceFactory csf = new LiteCoordinateSequenceFactory();
    private MathTransform identity = new AffineTransform2D(new AffineTransform());

    @Test
    public void testDecimateRing() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(4.0, 4.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)4L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testDecimatePseudoRing() {
        LineString g = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(4.0, 4.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)3L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testDecimateOpenTriangle() throws Exception {
        LineString g = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 0.0, 2.0, 2.0, 2.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(3.0, 3.0);
        d.decimateTransformGeneralize((Geometry)g, (MathTransform)new AffineTransform2D(new AffineTransform()));
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)4L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testDecimateRingEnvelope() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(20.0, 20.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertEquals((long)4L, (long)g.getCoordinateSequence().size());
    }

    @Test
    public void testNoDecimation() {
        LinearRing g = this.gf.createLinearRing(this.csf.create(new double[]{0.0, 0.0, 0.0, 10.0, 2.0, 10.0, 2.0, 0.0, 0.0, 0.0}));
        LinearRing original = (LinearRing)g.copy();
        Assert.assertTrue((boolean)g.isValid());
        Decimator d = new Decimator(-1.0, -1.0);
        d.decimate((Geometry)g);
        g.geometryChanged();
        Assert.assertTrue((boolean)g.isValid());
        Assert.assertTrue((boolean)original.equalsExact((Geometry)g));
    }

    @Test
    public void testDistance() throws Exception {
        LineString ls = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0}));
        Decimator d = new Decimator(this.identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize(ls.copy(), this.identity);
        Assert.assertEquals((long)6L, (long)ls.getNumPoints());
        d = new Decimator(this.identity, new Rectangle(0, 0, 5, 5), 1.0);
        d.decimateTransformGeneralize((Geometry)ls, this.identity);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        d = new Decimator(this.identity, new Rectangle(0, 0, 5, 5), 6.0);
        d.decimateTransformGeneralize((Geometry)ls, this.identity);
        Assert.assertEquals((long)2L, (long)ls.getNumPoints());
    }

    @Test
    public void testDecimate3DPoint() throws Exception {
        Point p = this.gf.createPoint(this.csf.create(new double[]{0.0, 1.0, 2.0}, 3));
        Decimator d = new Decimator(this.identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize((Geometry)p, this.identity);
        Assert.assertEquals((long)1L, (long)p.getNumPoints());
        Assert.assertEquals((long)2L, (long)p.getCoordinateSequence().getDimension());
    }

    @Test
    public void testDecimate3DLine() throws Exception {
        LineString ls = this.gf.createLineString(this.csf.create(new double[]{0.0, 0.0, 1.0, 1.0, 2.0, 1.0, 3.0, 3.0, 4.0, 4.0, 5.0, 5.0}, 3));
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        Decimator d = new Decimator(this.identity, new Rectangle(0, 0, 5, 5), 0.8);
        d.decimateTransformGeneralize((Geometry)ls, this.identity);
        Assert.assertEquals((long)4L, (long)ls.getNumPoints());
        Assert.assertEquals((long)2L, (long)ls.getCoordinateSequence().getDimension());
    }

    @Test
    public void testDecimationSpansInfinite() throws Exception {
        AbstractMathTransform mt = new AbstractMathTransform(){

            public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
                if (srcPts[0] == -0.5 || srcPts[1] == 0.5) {
                    dstPts[0] = Double.NaN;
                    dstPts[1] = Double.NaN;
                    dstPts[2] = Double.NaN;
                    dstPts[3] = Double.NaN;
                } else {
                    dstPts[0] = srcPts[0] * 10.0;
                    dstPts[1] = srcPts[1] * 10.0;
                    dstPts[2] = srcPts[2] * 10.0;
                    dstPts[3] = srcPts[3] * 10.0;
                }
            }

            public int getTargetDimensions() {
                return 2;
            }

            public int getSourceDimensions() {
                return 2;
            }
        };
        double[] dx = Decimator.computeGeneralizationDistances((MathTransform)mt, (Rectangle)new Rectangle(10, 10), (double)1.0);
        Assert.assertEquals((double)10.0, (double)dx[0], (double)0.0);
        Assert.assertEquals((double)10.0, (double)dx[1], (double)0.0);
    }

    @Test
    public void testDecimateCollection() throws Exception {
        WKTReader2 reader = new WKTReader2();
        MultiLineString origin = (MultiLineString)reader.read("MULTICURVE((0 0, 5 5),CIRCULARSTRING(4 0, 4 4, 8 4))");
        Decimator d = new Decimator(0.1, 0.1);
        MultiLineString simplified = (MultiLineString)d.decimateTransformGeneralize((Geometry)origin, this.identity);
        Assert.assertEquals((Object)origin.getGeometryN(0), (Object)simplified.getGeometryN(0));
        Assert.assertNotEquals((Object)origin.getGeometryN(1), (Object)simplified.getGeometryN(1));
        Assert.assertEquals((Object)"CircularString", (Object)origin.getGeometryN(1).getGeometryType());
        Assert.assertEquals((Object)"LineString", (Object)simplified.getGeometryN(1).getGeometryType());
    }
}

